import java.sql.*;

public class Main {

    private static final String connStr = "jdbc:postgresql://127.0.0.1:5432/dblab";
    private static final String user = "postgres";
    private static final String pass = "123456";

    public static void main(String[] args) {
        try {
            Connection conn = DriverManager.getConnection(connStr, user, pass);

            PreparedStatement statement = conn.prepareStatement("INSERT INTO test(name, grade) VALUES(?,?) RETURNING id;");
            statement.setString(1, "114514");
            statement.setInt(2, 1919810);
            ResultSet resultSet = statement.executeQuery();
            int result = -1;
            while (resultSet.next()) {
                result = resultSet.getInt(1);
            }
            System.out.println("inserted, return id: " + result);

            conn.close();

            testRead(result);
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void testRead(int id) throws SQLException {
        Connection conn = DriverManager.getConnection(connStr, user, pass);
        PreparedStatement statement = conn.prepareStatement("SELECT id,name,grade FROM test WHERE id=?;");
        statement.setInt(1, id);
        ResultSet resultSet = statement.executeQuery();
        while (resultSet.next()) {
            int serialID = resultSet.getInt(1);
            String name = resultSet.getString(2);
            int grade = resultSet.getInt(3);
            System.out.printf("id:%d name:%s grade:%d\n", serialID, name, grade);
        }
        conn.close();
    }
}

