# 📶选择一台合适的路由器

by [@sparkcyf](https://github.com/sparkcyf)

::: tip

本文参考了acwifi.net的[相关文章](https://www.acwifi.net/9985.html)。

本文写于2020年8月。

:::

## 我有需要购买路由器吗？

除非你有如以下的需求，学校提供的网络服务一般来说已经够用了。

- 居住于湖畔，并且办了电信的自费宽带。
- 觉得学校提供的无线速率太慢（学校的路由器使用802.11ac 40Mhz频宽（2\*2/3\*3），最大单向传输速率约为450Mbps）。
- 宿舍的无线信号覆盖较差。
- 需要连接其他电子设备（如台式机，开发板，存储服务器等），或需要对局域网进行控制。
- 使用了无DHCPv6功能的设备，但还想使用IPv6。

## Wi-Fi5还是Wi-Fi6？

目前，苹果与安卓厂商的旗舰设备均已经支持Wi-Fi6（802.11ax），不少使用Intel网卡的新电脑也已经支持Wi-Fi6。相对Wi-Fi5（802.11ac），Wi-Fi6能能够带来显著的速度提升。

> 随着一波新品WI-FI 6上市，那么问题来了：“廉颇老矣,尚能饭否”。一些老的WI-FI 5路由器还可以购买吗？我不知道，因为没对比过，最近玩廉颇老是输，才想起这个问题。但可以肯定的是同一台WI-FI 6路由器，用支持WI-FI 6的手机会比只支持WI-FI 5的手机在近、中、远的距离上速度都要快，再远就两者都没有信号了。

但值得注意的是，除了Wi-Fi技术的版本，天线阵列数量和路由器支持的频宽也是选择路由器的重要因素。比如，支持160Mhz的Wi-Fi5路由器相比只支持80Mhz的Wi-Fi6路由器就能达到更高的理论带宽速度。

同时，苹果目前发布的电脑所内置的网卡支持3\*3天线，但不支持160Mhz和Wi-Fi6，若你使用苹果电脑，可以根据这一点选择合适的路由器。

## 我应该重点关注什么？

- 不要再买百兆/2.4G only的路由器了。**请至少购买一个有千兆网口，支持双频的路由器**（况且现在千兆双频的路由器也只要100不到）。

- **关注路由器是否支持IPv6**。教育网的一大优势就是IPv6所带来的资源和更加空闲的网络。你同是还应该关注路由器的相关设置中是否提供了IPv6防火墙的开关功能。
- **能否刷机**。由于电信的自费网络需要登陆，还会定时把你踢下线，在路由器上部署一个自动登录脚本是相当有必要的，但这就需要路由器能刷机，或者能够拿到路由器的控制权了。

## 按照价格选择

### 100元左右

99元的水星D191G或D196G，3\*3天线，配合3\*3天线的网卡，实测最快传输速率可达700Mbps左右。支持IPv6，但无法控制IPv6防火墙。系统由于用的是vxWorks，刷机就不用想了。

150左右的红米ac2100。3\*3天线，支持160Mhz带宽，还可以刷机，在200元以内算是性价比最优的路由器了。

### 200-400元

**200元左右的华为AX3/荣耀路由pro2**，2\*2天线。160Mhz的Wi-Fi6路由器，实测使用Intel的AX200网卡也可以跑到700Mbps左右（理论速率1.2Gbps）。支持IPv6，也有一些华为特色功能，也带USB口。但依旧没有IPv6防火墙设置。华为的路由器也不用想着刷机了。

**300元左右的小米AX1800**。2\*2天线，支持80Mhz，没有USB口。带外置功放，相比ax3信号会好一些。已经有人开出了ssh，支持刷机估计是迟早的事情。

**300元左右的小米AX3 Pro**。相比AX3多了外置功放，但宿舍这么小的空间，没有的话问题也不太大。

### 400元+

**600元左右的小米AX3600**。4\*4天线，支持160Mhz。参数上来看还是很不错的。也能开SSH，估计过段时间就能刷机了。

## 我需要软路由吗？

如果你需要进行有加解密运算的工作，那软路由还是有必要的。或者如果你只是把路由器当AP，而需要另一个计算设备处理路由相关的工作，那也可以考虑购置一个。

