# 🏫建筑与设施

## 校园街景<Badge text="Beta" type="tip"/>

::: tip
街景图像拍摄于`2021年6月`，若想了解街景拍摄的流程，请参考[此链接](https://sparktour.me/2021/06/16/campus-streetview/)。
:::

[点击此处](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node38,210,0,120,10)或通过下方的嵌入页面查看校园街景地图！

<iframe src="https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node38,210,0,120,10" name="iframe_window" width="100%" height="600" scrolling="no" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe>

<Adsense_unit>
</Adsense_unit>

## 校园地图与主要建筑

![校园地图](https://cdn.jsdelivr.net/gh/sustech-cra/sustech-online-ng@master/docs/facility/campus-map.png)

上图是南科大的校园平面图。在校园内，建筑大都处于校园西侧。

![致新书院绘制的卡通版地图](https://mirrors.sustech.edu.cn/site/sustech-online/img/campus-map/campus-map-cartoon-version.png)

*(如果您想直接看带有地点标记的互动式全景图以了解学校，请直接翻到[本页底部](#航拍全景看校园)。)*

### 新校区（一般称为山下）

![一期校园](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/underhill.jpg)

上图中，左上角为国际会议中心，左下角为正在建设中的理学院；中下位置为行政楼和琳恩图书馆，中上方从左到右为第四科研楼到第一科研楼；正中间从左到右是第二教学楼，检测中心和第一教学楼；右侧为南科大中心。

#### 琳恩图书馆

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node149,-122,-17,120)

![图书馆与行政楼](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/library-and-administration-building.jpg)

琳恩图书馆是南科大的第一个，也是最大图书馆，在2020年前，他同时是南科大的唯一图书馆。图书馆名字中“LYNN”的来历，是因为一位匿名的香港友好人士向南方科技大学教育基金会捐赠港币2000万元，因此他将图书馆冠名为“琳恩图书馆”（LYNN LIBRARY）。

- [琳恩图书馆的历史](https://sustc.wiki/琳恩图书馆)

#### 行政楼

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node49,-109,13,110)

南科大是因为去行政化出名，但学校还是建了一栋独立的行政楼。在行政楼中长期办公的除了校领导和行政人员，主要还有校宣传部，信息中心和校园卡服务中心：如果需要**挂失，补办校园卡**，需要去行政楼一楼的校园卡服务中心办理。

行政楼的一楼还有一个早上会卖面包，一些饮品的**面包房**和在南科大校内人尽皆知的[**行政楼厕所**](https://mp.weixin.qq.com/s/bw6Nl_gBkOiqtAXXMQW-Mw)。

#### 第一教学楼

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node94,-49,14,97)

![第一教学楼](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/第一教学楼.jpg)

简称“**一教**”。在学校二期工程完成之前，本科生绝大部分基础课都会在第一教学楼上。

一教分为南北两翼，南翼主要是教室：一楼的大部分教室都是可以容纳150人+的**大型教室**，平时主要用于上通识基础课和思政课；二楼主要用作了**自习室**；三楼和四楼有几间教室平时固定用于英语课程，其他的教室则是用于人数较少的课程。

北翼则大部分为实验室：一楼为**电子系实验室**，二楼为**化学系实验室**，三楼四楼则是生物系实验室。北翼的外墙是一块LED大屏幕，平时用于播放讲座信息或是学校的宣传片，晚上会放新闻联播。

一教的北侧有一个[赛百味](https://amap.com/place/B0FFK1Q96N)，一般在课间会排队。

在一教的楼顶可以看到整个山下，和建设中的公共教学楼和理学院。

#### 检测中心

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node65,-68,7,120)

内部主要是一些实验室，包括安装了光刻设备的超净间等。

#### 第二教学楼

[进入街景](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node62,-54,3,97)


第二教学楼主要教室都是**机房**（2019年换的电脑是i7-8700K+1080Ti)，一般会用于上电子系，计算机系的实验课和一些电脑测评/考试。二教还有**一间多功能教室**，现在一般用于乐器排练和美术课程。

#### 第一科研楼

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node100,89,16,120)

学校一期建筑之一，包含各种实验室。内部是一个大天井，二楼有一个给机器人或者是智能机械的测试平台。

#### 第二科研楼

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node128,-71,28,120)

主要是实验室和教授办公室。

#### 第三科研楼

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node84,-75,23,120)

主要是实验室和教授办公室。冷冻电镜也设置于此。

#### 第四科研楼（台州楼）

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node84,-75,23,120)

主要是实验室和教授办公室。为什么叫台州楼呢？这栋楼里面有一个[“南方科技大学台州研究院”](http://zj.ifeng.com/a/20190118/7173526_0.shtml)，然后校长的籍贯也是台州，也可能有点关系。

#### 南科大中心（学生食堂）

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node97,93,-2,120)


##### 学生餐厅

学校的第一个食堂，由南科大运营，一楼是打菜，二楼有小炒和西餐。

详细内容请见[餐饮/学生餐厅（一期）](/life/catering/#学生餐厅（一期）)。

##### 一丹图书馆

南科大的第二个图书馆，内含24小时自习空间。

#### 国际会议中心

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node18,108,0,120)



![国际会议中心](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/interview-center.jpg)

### 湖畔

![湖畔宿舍航拍](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/lakeside-aerial.jpg)

在上图中，中间按顺时针顺序依次是是湖畔宿舍，九华苑，游泳馆和风雨操场。

#### 湖畔宿舍群

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node174,-155,17,109)



![致仁书院](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/zhiren-college.jpg)

湖畔宿舍目前主要居住**致仁书院**，**树德书院**，**致诚书院**的同学。其中，湖畔1-3栋是四人间，4-6栋则是双人间。湖畔1栋楼下是学生事务中心，3栋的楼下有一间小超市，5栋楼下则是收发室。

湖畔沿湖一侧有若干建筑，包括**书院活动室**，**湖畔健身房**和**舞蹈房**。这些建筑的上面是一个大阳台，可以从六栋旁边的楼梯上去。

![书院活动室上方的阳台](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/湖畔阳台.jpg)

>南科人当然是住在南科大宿舍里面了。南科大现阶段三大宿舍区：湖畔、荔园、欣园，选书院的结果已经出来了，宿舍在哪里大家应该都有所了解。在介绍宿舍区之前，先给大家普及一下教学楼的位置：南科大教学区域主要分为两块：第一、第二教学楼区域和荔园教学楼区域，俗称山上和山下。湖畔宿舍区位于这两大教学区的中间位置，去哪儿上课都比较方便；荔园紧贴着荔园教学区，不过到一教上课就需要下山；欣园在山顶，位置最远，上课必须下山。在校内正在建设的二期宿舍据说很漂亮，不过那是2019年的事情了。

> 不管之后会不会有什么宿舍的调整，毕竟这是每个人都要花很多时间呆的地方，还是先要把自己的寝室好好地装饰装饰。之前大家在网上羡慕的各种“最美寝室”，终于也能自己动手布置了。地板、茶几、贴纸，提升寝室格调；置物架、收纳盒、挂袋，提高生活效率；衣柜灯、小挂钩、脚踏垫，注重生活细节；LED挂灯、木头钟，提高学习效率……创意无限，大胆想象，把寝室变成自己心中的样子吧。

- [湖畔的更多历史](https://sustc.wiki/湖畔)

| 楼栋 | 入住学生归属 |
| :--: | :----------: |
|  1   |     致仁     |
|  2   |     致仁     |
|  3   |     致诚     |
|  4   |    研究生    |
|  5   |     研究生、树德     |
|  6   |      研究生、树德     |



#### 九华苑

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node709,96,0,120)



一共有九栋别墅，主要居住院士级别的教授，因此也被同学称之为“院士楼”。平时门口的保安不太欢迎同学上去，可能会赶人。

#### 风雨操场

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node719,-52,8,120)



![风雨操场](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/sports-center.jpg)

风雨操场的南侧包括**排球场**，**搏击馆**和**室内篮球场**，风雨操场的二层有一个废弃的网球场（可能是因为怕网球打伤人）。**室内设施没有空调**，夏天会比较热。大一上的体育课大都会在此处进行。

#### 游泳馆

包含一个标准游泳池和旁边的更衣室。游泳池需要凭校园卡换取手牌入场，一般不对校外人员开放。

- [游泳馆](https://sustc.wiki/游泳馆)

### 二期宿舍

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node704,-15,17,120)



![二期宿舍10栋与餐厅](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/p2-dormitory.jpg)

于2019年8月落成的新宿舍区域，也是未来大部分同学（本科生，研究生，博士生）的居住区域。但与湖畔宿舍相比，二期宿舍缺少独立卫生间，宿舍面积也相对更小一些，但二期宿舍全部配备了电梯。

二期宿舍中部有一个两层的二期宿舍学生餐厅，西侧则有一个小型图书馆，学校对他的定位更像是“自习室”。

- [🏢入住新宿舍](/life/dormitory)

| 楼栋 |    入住学生归属    |
| :--: | :----------------: |
|  7   |          博士生          |
|  8   |        博士生         |
|  9   |       博士生       |
|  10  |       博士生       |
|  11  | 新生楼（大一学生） |
|  12  |       研究生       |
|  13  |        树德        |
|  14  |        致新        |
|  15  |        树仁        |
|  16  |        树礼        |
|  17  |         研究生           |

### 工学院

![建设中的工学院](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/Engineering_College_Building_of_Southern_University_of_Science_and_Technology_Under_Construction.jpg)

上图是正在建设中的工学院。

工学院分为南座和北座。

### 荔园

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node614,-99,2,94)

值得一提的是，荔园，创园，慧园与欣园都是原二线关外工业区厂房改建而成的。

![荔园，慧园与欣园](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/liyuan-huiyuann-xinyuan.jpg)

在上图中，左上角是荔园与创园，左下角是慧园，右侧是欣园。

![荔园入口](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/liyuan-gate.jpg)

荔园的1，2，5栋主要是教室和实验室，余下部分则为宿舍区域。

![荔园一栋](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/liyuan-block1.jpg)

荔园5栋的1，2楼是餐厅，由外包商运营。6栋楼下有一个超市。

- [荔园](https://sustc.wiki/荔园)

### 创园

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node321,117,22,120)

许多院系的实验室和办公区域设置于创园。其中，创园一栋由于进驻了学校的一些机构和校办公司，因此装修水平明显较其他栋高级。

### 慧园

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node310,188,16,120)

许多院系的实验室和办公区域设置于创园。

### 欣园

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node296,-177,5,120)


欣园主要是宿舍区。

- [欣园](https://sustc.wiki/欣园)

### 校园东南区域

![校园东南区域](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/southwest.jpg)

在上图中，左侧是田径场和润扬体育馆，中间是教师公寓，右侧是学术交流中心与人文社会科学学院。

#### 教师公寓与专家公寓

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node208,25,90,120)


八栋建筑中，有六栋为教师公寓，两栋为专家公寓。

教师公寓主要供教职人员居住，一楼设有一间教工餐厅和传言只有faculty才能进的 Faculty Club。森林印务也设置于此。

专家公寓对外开放，以宾馆的形式运营，一楼有一间西餐厅，一间中餐厅和一间报告厅。

> 家长要来学校，住宿的首选当然是专家公寓。就在校内，房间内饰朴素干净，价钱也很亲民，比校外的酒店会便宜100左右。要提醒的是专家公寓是不接受电话预定的，必须要亲自去前台预定。尤其是校园开放日的那几天，房间会非常紧张，最好是提前3到5天预定好。

- [专家公寓](https://sustc.wiki/专家公寓)

#### 棒球场

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node503,-87,-6,120)


位于专家公寓南侧，使用率不是很高。每年会举办一次[“海峡两岸学生棒球联赛”](https://newshub.sustech.edu.cn/zh/html/201912/30570.html)。

#### 办公楼（新行政楼）与人文社科学院

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node224,-9,-1,120)


### 运动场

#### 润扬体育馆

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node448,132,11,70)


![润杨体育馆](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/润杨体育馆.jpg)

叫“润扬体育馆”的原因是因为体育馆是润杨集团[冠名](https://newshub.sustech.edu.cn/zh/html/201909/26624.html)的。

体育馆南侧目前是野战场地，学校购置了基于红外线的模拟枪，可以打真人CS。这里还有一面攀岩墙。

#### 松禾体育场（田径场）

[![进入街景](./streetview.svg)](https://mirrors.sustech.edu.cn/site/sustech-pano/202106/#node449,-104,-23,120)


![松禾体育场](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/松禾体育场.jpg)

由松禾资本[冠名](https://newshub.sustech.edu.cn/zh/html/201704/5996.html)。

### 步行公园（后山）

![步行公园](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/hill.jpg)

上图的左侧为长岭陂水库，中间为步行公园，右侧为润扬体育馆，远处的轨道为长岭陂地铁站。

在后山（步行公园）上可以望见长岭陂水库，智园，长岭陂地铁站和正在建设中的医学院。

后山的体育馆后方的位置有一块石头，在二期宿舍建成之前是学校的最高点，可以看到整个校园。

### 大沙河

![一号门所见的大沙河](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/大沙河-gate1.jpg)

大沙河发源自长岭陂水库泄洪渠，并流经南科大的南侧。


## 航拍全景看校园

::: warning
航拍图像拍摄于`2019年6月`，校园内部分建筑此时仍在修建。自此之后，学校原则上不再允许学生在校内飞行无人机。
:::

![湖畔全景](https://cdn.jsdelivr.net/gh/sustech-cra/sustech-online-ng@master/docs/facility/campus-pano.jpg)

### 同学自行拍摄的互动式校园全景
[一次观看全部全景图像](./panolens)

#### 分区观看
- [夜景全景](https://mirrors.sustech.edu.cn/site/sustech-online/panolens/night.html)
- [一期校园（校园南侧）](https://mirrors.sustech.edu.cn/site/sustech-online/panolens/underhill.html)
- [湖畔（校园中心）](https://mirrors.sustech.edu.cn/site/sustech-online/panolens/lakeside.html)
- [荔园，二期宿舍（校园北侧）](https://mirrors.sustech.edu.cn/site/sustech-online/panolens/liyuan.html)
- [慧园，欣园（校园东北侧）](https://mirrors.sustech.edu.cn/site/sustech-online/panolens/huiyuan.html)
- [工学院 （校园西北侧）](https://mirrors.sustech.edu.cn/site/sustech-online/panolens/aoe.html)


## 图片版权

- CC0
  - [校园地图](https://cdn.jsdelivr.net/gh/sustech-cra/sustech-online-ng@master/docs/facility/campus-map.png)/深圳规划局
- [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/deed.zh)
  - [图书馆与行政楼](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/library-and-administration-building.jpg)/sparktour
  - [风雨操场](https://commons.wikimedia.org/wiki/File:Arial_image_of_the_sports_center_of_SUSTech.jpg)/sparktour
  - [书院活动室上方的阳台](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/湖畔阳台.jpg)/sparktour
  - [风雨操场](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/sports-center.jpg)/sparktour
  - [建设中的工学院](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/Engineering_College_Building_of_Southern_University_of_Science_and_Technology_Under_Construction.jpg)/sparktour
- 权利归作者所有
  - [一期校园](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/underhill.jpg)/sparktour
  - [第一教学楼](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/第一教学楼.jpg)/南方科技大学
  - [国际会议中心](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/interview-center.jpg)/南方科技大学
  - [湖畔宿舍航拍](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/lakeside-aerial.jpg)/sparktour
  - [致仁书院](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/zhiren-college.jpg)/南方科技大学
  - [二期宿舍10栋与餐厅](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/p2-dormitory.jpg)/南方科技大学
  - [荔园，慧园与欣园](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/liyuan-huiyuann-xinyuan.jpg)/sparktour
  - [校园东南区域](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/southwest.jpg)/sparktour
  - [步行公园](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/hill.jpg)/sparktour
  - [润杨体育馆](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/润杨体育馆.jpg)/南方科技大学
  - [松禾体育场](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/松禾体育场.jpg)/南方科技大学
  - [一号门所见的大沙河](https://mirrors.sustech.edu.cn/site/sustech-online/img/facility/buildings/大沙河-gate1.jpg)/南方科技大学
  - [湖畔全景](https://cdn.jsdelivr.net/gh/sustech-cra/sustech-online-ng@master/docs/facility/campus-pano.jpg)/sparktour
