# Changelog

此处记载了 SUSTechThesis 中所有值得留意的改动，格式参照 [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)。

点击版本号即可在 GitHub 上查看相邻版本间的代码变动。

Changelog 维护应保持最新版本在文件上面的原则，日期格式按照 ISO 8601 的标准: `YYYY-MM-DD`.

#### 变更分类：*major*, *minor*, *bug-fix*。

#### *major* release trigger:

- `Changed`：现有功能变更。
- `Removed`：现有功能移除。

#### *minor* release trigger:

- `Added`：引入新功能
- `Deprecated`：标记即将被删除的功能。

#### *bug-fix* release trigger:

- `Fixed`：错误修复.
- `Security`：安全漏洞修复.

#### 使用提示

- 未发布版本使用形如 "`[Unreleased]`" 作为二级标题，
- 预发布版本使用形如 "`[1.0.2-rc.1] - 2021-06-11`" 作为二级标题，
- 正式发布版本使用形如 "`[1.0.1] - 2020-07-25`" 作为二级标题。

## [1.3.4] - 2021-10-21

### Changed
-  更新注释
-  更新文档
-  修正专业型选项的拼写

## [1.3.3] - 2021-10-19

### Changed
-  【题名页】研究生姓名一栏改为“学位申请人”
-  【题名页】专业选项名称修改，学术型博/硕士为“学科名称”，专业型博/硕士为“专业类别”。
-  条目内容对齐方式修改 ，第二行顶格
-  参考文献的著录作者姓全大写，即改为GB/T 7714-2015

### Added
- 增加注释
- 增加符号和缩略语说明，并列于目录

### Removed
- 由于引入 bibunits 对个人简历部分的文献进行管理，不再兼容 BibLaTeX 管理文献。

## [1.3.2] - 2021-08-23

### Changed
-  更新字体文件名

## [1.3.1] - 2021-08-17

### Changed
-  更新声明括号
-  修改英文的目录和页眉

## [1.3.0] - 2021-08-01

### Changed

- 【封面】封面“硕士学位论文” 修改为宋体 24 号字加粗。
- 【封面】封面论文题目中文采用黑体 22 号字。
- 【封面】封面作者及指导教师信息采用宋体 18 号字。
- 【封面】封面日期填写学位论文成文打印的日期，采用用宋体 18 号字。
- 【题名页】题目采用中文黑体 22 号字，英文Times New Roman 22号字。
- 【目录】修正目录行距目录。
- 【正文】修改条目列表，默认缩进2个中文字符，悬挂缩进，并按要求更新默认样式。
- 【正文】子图、子表改用成对圆括号。
- 【正文】修改默认数学字体为 Cambria Math。
- 【声明】对齐了声明中的签名
- 【声明】变更声明顺序，位于在答辩委员会后。
- 【学术成果】修正学术成果部分的参考文献字体大小，改为10.5pt。
- 【学术成果】修改学术成果用节标题，前面不加（一）（二）等，序号从[1]开始往后递推。
- 【学术成果】修改学术成果用节标题样式。

### Added
- 【字体】添加加载外部字体选项，改善非 Windows 系统下的字体编译。

## [1.2.0] - 2021-06-30

### Added
- 添加使用文档 `sustechthesis.pdf`
- 改回 `dtx` 文件生成 `cls` 文件的形式，`dtx` 文件内有大量的注释方便后期维护。

### Changed
- 更改封面英文标题为自动大写

## [1.1.10] - 2021-06-14
### Changed
- 修正封面，使得表域居中
- 手动调整 chapter 标题的行距
- 声明行距修改
- 更改声明形式，将声明移入cls
- 为声明命令添加可选参数，使得可以合并扫描的声明文件
- 重新定义封面副标题，并配置副标题格式
- 更新测试脚本
- 更新文件名

### Fixed
- 修复封面标题行距
- 修正表格等浮动体内部的字体为 11 bp

## [1.1.9] - 2021-06-10
### Changed
- 更新封面的间距
- 更新关键词缩进，第二行应与第一行平齐
- 参考文献改用传统 BibTeX + natbib 宏包
- 重命名南科大特色格式
- 更新测试脚本
- 更新声明的缩进

### Fixed
- 修复封面字体

## [1.1.8] - 2021-06-09
### Changed
- 同一修改 pt 为 bp
- 移除一些无关的注释

### Fixed
- 修复封面日期为思源宋体

## [1.1.7] - 2021-06-08
### Changed
- 独创声明加入目录
- 更新英文独创声明

### Fixed
- 拼写错误

## [1.1.6] - 2021-06-02
### Changed
- 分类答辩日期与封面发布日期选项
- exanple 中改用 biblatex
- 更新参考文献样式文件

### Fixed
- 英文声明的拼写错误

## [1.1.5] - 2021-05-29
### Changed
- 更新英文摘要大小写：中文为主要语言首字母大写，英文为主要语言全大写。
- 更新原创性声明和使用授权说明

## [1.1.4] - 2021-05-28
### Fixed
- 子图序号添加空格

## [1.1.3] - 2021-05-28
### Changed
- 更新注释
- 更新文档

### Fixed
- 修改表格和图表的标号用横线连接，子图仅有右括号
- 修复工硕英文
- 改写摘要英文为首字母大写

## [1.1.2] - 2021-05-27
### Added
- 添加委员会页面
- 增加论文字数统计

### Changed
- 更新注释，目录中移除独创声明 fix #7

## [1.0.6] - 2021-04-27
### Added
- 加入镜像站链接，更新封面字体。

## [1.0.4] - 2021-04-10
### Fixed
- 修复封面超长英文系名导致的overbox问题。

## [1.0.1] - 2021-03-17
### Added
- 从清华模版 ThuThesis v7.1.0 初始化，并进行简单适配。