% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-style.R
\name{print.hyplot}
\alias{print.hyplot}
\alias{set_corrplot_style}
\alias{set_default_style}
\title{Set Default Color Pallete}
\usage{
\method{print}{hyplot}(x, ...)

set_corrplot_style(
  colours = NULL,
  breaks = seq(-1, 1, length.out = 5),
  labels = breaks,
  limits = c(-1, 1),
  scale = NULL,
  ...
)

set_default_style()
}
\arguments{
\item{x}{a hyplot object.}

\item{...}{other parameters passing to \code{scale_fill_gradientn}.}

\item{colours}{vector of colours to use for n-colour gradient.}

\item{breaks}{a numeric vector of positions.}

\item{labels}{a character vector giving labels (must be same length as breaks).}

\item{limits}{a numeric vector of length two providing limits of the scale.}

\item{scale}{NULL or a \code{Scale} object.}
}
\description{
Set default color pallete for \code{\link{qcorrplot}}.
}
\examples{
## use corrplot style
set_corrplot_style()
qcorrplot(mtcars) + geom_shaping(marker = "circle")
## use custom colour palette
set_corrplot_style(colours = c("red", "white", "blue"))
qcorrplot(mtcars) + geom_shaping(marker = "circle")
## use custom scale
set_corrplot_style(scale = ggplot2::scale_fill_viridis_c(limits = c(-1, 1)))
qcorrplot(mtcars) + geom_shaping(marker = "circle")
## reset to default scale
set_default_style()
qcorrplot(mtcars) + geom_shaping(marker = "circle")
}
\author{
Hou Yun
}
