% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_by.R
\name{reorder_by}
\alias{reorder_by}
\alias{reorder_by.matrix}
\alias{reorder_by.data.frame}
\alias{reorder_by.correlate}
\alias{reorder_by.matrix_data}
\alias{reorder_by.md_tbl}
\title{Re-sorting Matrix Data}
\usage{
reorder_by(x, ...)

\method{reorder_by}{matrix}(
  x,
  by_rows = "hclust",
  by_cols = by_rows,
  dist_fun = dist_func(),
  ...
)

\method{reorder_by}{data.frame}(
  x,
  by_rows = "hclust",
  by_cols = by_rows,
  dist_fun = dist_func(),
  ...
)

\method{reorder_by}{correlate}(x, by_rows = "hclust", by_cols = by_rows, dist_fun = NULL, ...)

\method{reorder_by}{matrix_data}(
  x,
  by_rows = "hclust",
  by_cols = by_rows,
  dist_fun = dist_func(),
  ...
)

\method{reorder_by}{md_tbl}(x, by_rows = NULL, by_cols = NULL, ...)
}
\arguments{
\item{x}{matrix data.}

\item{...}{other parameters.}

\item{by_rows, by_cols}{method of reorder, default is "hclust".}

\item{dist_fun}{a function to calculute distance matrix.}
}
\value{
same object with `x`.
}
\description{
Resort matrix data by "hclust", "dendrogram", and so on.
}
\author{
Hou Yun
}
