% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental-fun.R
\name{qpairs}
\alias{qpairs}
\title{Init pairs plot}
\usage{
qpairs(
  data,
  mapping = NULL,
  expansion = NULL,
  axis_child = TRUE,
  data2 = NULL,
  except = NULL,
  type = "full",
  diag = TRUE,
  rasterize = TRUE,
  res = NULL,
  grid_col = "grey50",
  grid_size = 0.25,
  drop = TRUE,
  use_md = NULL,
  ...
)
}
\arguments{
\item{data}{a data frame.}

\item{mapping}{default list of aesthetic mappings to use for plot.}

\item{expansion}{a list of x/y axis expansion of child plot.}

\item{axis_child}{logical, if (TRUE) will add child plot axis.}

\item{data2}{NULL or a data frame.}

\item{except}{character, which variable will not be contained in plot.}

\item{type}{character, "full" (default), "upper" or "lower", display
full matrix, lower triangular or upper triangular matrix.}

\item{diag}{logical, if TRUE (default) will keep the diagonal of matrix data.}

\item{rasterize}{logical, whether to convert raster image before drawing.}

\item{res}{positive numeric, used to set the resolution of raster.}

\item{grid_col}{colour of panel grid.}

\item{grid_size}{size of panel grid.}

\item{drop}{logical. If TRUE, the unused labels will be removed.}

\item{use_md}{logical. if TRUE, will use \code{ggtext::element_markdown()} to
draw the axis labels.}

\item{...}{passed to \code{guide_child_axis()}.}
}
\value{
a ggplot object.
}
\description{
This functions can be used to init pairs plot based on ggplot.
}
\examples{
\dontrun{
qpairs(iris) + geom_pairs()
}
}
\author{
Hou Yun
}
