% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcorrplot.R
\name{qcorrplot}
\alias{qcorrplot}
\alias{qcorrplot.cor_md_tbl}
\alias{qcorrplot.matrix}
\alias{qcorrplot.data.frame}
\alias{qcorrplot.default}
\title{Correlation Plot
This functions can be used to visualize simply and directly a correlation matrix.}
\usage{
qcorrplot(data, ...)

\method{qcorrplot}{cor_md_tbl}(
  data,
  mapping = NULL,
  drop = FALSE,
  parse = FALSE,
  grid_col = "grey50",
  grid_size = 0.25,
  fixed = TRUE,
  facets = list(),
  facets_order = NULL,
  use_md,
  ...
)

\method{qcorrplot}{matrix}(
  data,
  mapping = NULL,
  drop = FALSE,
  parse = FALSE,
  grid_col = "grey50",
  grid_size = 0.25,
  fixed = TRUE,
  facets = list(),
  use_md,
  ...
)

\method{qcorrplot}{data.frame}(
  data,
  mapping = NULL,
  drop = FALSE,
  parse = FALSE,
  grid_col = "grey50",
  grid_size = 0.25,
  fixed = TRUE,
  facets = list(),
  use_md,
  ...
)

\method{qcorrplot}{default}(
  data,
  mapping = NULL,
  drop = FALSE,
  parse = FALSE,
  grid_col = "grey50",
  grid_size = 0.25,
  fixed = TRUE,
  facets = list(),
  facets_order = NULL,
  use_md,
  ...
)
}
\arguments{
\item{data}{one of 'correlate', 'rcorr' or 'corr.test' object.}

\item{...}{other parameters.}

\item{mapping}{default list of aesthetic mappings to use for plot.}

\item{drop}{logical, if TRUE will drop unused axis labels.}

\item{parse}{logical or function generated by \code{parse_func()}.}

\item{grid_col}{colour of panel grid.}

\item{grid_size}{size of panel grid.}

\item{fixed}{if TRUE (default), will add \code{coord_fixed()} to plot.}

\item{facets}{NULL or a parameters list of \code{facet_wrap}.}

\item{facets_order}{character vector to set the order of facet panels.}

\item{use_md}{deprecated.}
}
\value{
a gg object.
}
\description{
Correlation Plot
This functions can be used to visualize simply and directly a correlation matrix.
}
\examples{
### type = "full"
qcorrplot(correlate(mtcars)) +
  geom_square()
### type = "lower"
qcorrplot(correlate(mtcars), type = "lower") +
  geom_square()
### type = "upper"
qcorrplot(correlate(mtcars), type = "upper") +
  geom_square()
}
\author{
Hou Yun
}
