% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mantel-test.R
\name{mantel_test}
\alias{mantel_test}
\title{Mantel test}
\usage{
mantel_test(
  spec,
  env,
  group = NULL,
  env_ctrl = NULL,
  mantel_fun = "mantel",
  spec_select = NULL,
  env_select = NULL,
  na_omit = TRUE,
  spec_dist = NULL,
  env_dist = NULL,
  env_ctrl_dist = NULL,
  seed = 123,
  ...
)
}
\arguments{
\item{spec, env}{data frame object.}

\item{group}{vector for grouping the rows.}

\item{env_ctrl}{NULL (default), TRUE or a data frame.}

\item{mantel_fun}{string, function of mantel test.
 \itemize{
   \item{\code{"mantel"} will use \code{vegan::mantel()} (default).}
   \item{\code{"mantel.randtest"} will use \code{ade4::mantel.randtest()}.}
   \item{\code{"mantel.rtest"} will use \code{ade4::mantel.rtest()}.}
   \item{\code{"mantel.partial"} will use \code{vegan::mantel.partial()}.}
}}

\item{spec_select, env_select}{NULL (default), numeric or character vector index of columns.}

\item{na_omit}{if TRUE (default), the incomplete cases will be removed.}

\item{spec_dist}{NULL (default) or \code{dist_func()}.}

\item{env_dist}{NULL (default) or \code{dist_func()}.}

\item{env_ctrl_dist}{NULL (default) or \code{dist_func()}.}

\item{seed}{a integer value.}

\item{...}{extra params passing to \code{mantel_fun}.}
}
\value{
a data.frame.
}
\description{
Mantel and partial mantel test for dissimilarity matrices
}
\examples{
\dontrun{
library(vegan)
data("varespec")
data("varechem")

## set group id of `spec` on columns by `spec_select`
mantel_test(varespec, varechem,
  spec_select = list(spec01 = 1:5, spec02 = 6:12))

## set group id of `spec` on columns by `spec_select`
## set group id of `env` on columns by `env_select`
mantel_test(varespec, varechem,
  spec_select = list(spec01 = 1:5, spec02 = 6:12),
  env_select = list(env01 = 1:5, env02 = 6:10, env03 = 11:14))

## set group id of all data on rows by `group`
set.seed(20211123)
sam_grp <- sample(paste0("sample", 1:3), 24, replace = TRUE)
mantel_test(varespec, varechem, group = sam_grp)

## partial mantel test
m <- matrix(rnorm(24*5), nrow = 24)
mantel_test(varespec, varechem, env_ctrl = m,
mantel_fun = "mantel.partial")
}
}
\author{
Hou Yun
}
