% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-magic-text.R
\name{latex_expression}
\alias{latex_expression}
\alias{parse_func}
\title{Converts a LaTeX String to Expression}
\usage{
latex_expression(
  x,
  sup = NULL,
  sub = NULL,
  space = "\\\\ ",
  user_defined = list(),
  env = parent.frame(),
  mode = "formula",
  output = "character",
  ...
)

parse_func(..., output = "character")
}
\arguments{
\item{x}{a character vector.}

\item{sup}{one-length character, indicates that characters after this is superscript.}

\item{sub}{one-length character, indicates that characters after this is subscript.}

\item{space}{if `mode = "formula"`, will replace space in x with it.}

\item{user_defined}{user-defined command, see \code{?latex2exp::TeX} for details.}

\item{env}{environment to evaluate each expression in.}

\item{mode}{'inline' means string is normal text with some formula,
and 'formula' means all string is formula.}

\item{output}{the type of returned object, should be expression or character.}

\item{...}{other parameters passing to \code{latex2exp::TeX()}.}
}
\description{
Helper function to convert a LaTeX string to expression.
}
\examples{
name <- c("A_2", "B^3", "C_2", "D^{123 + x}")
name <- latex_expression(name)
}
\author{
Hou Yun
}
