% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyplot.R
\name{hyplot}
\alias{hyplot}
\title{Initialize hyplot}
\usage{
hyplot(
  md,
  mapping = NULL,
  drop = TRUE,
  parse = FALSE,
  facets = list(),
  facets_order = NULL,
  use_md,
  ...
)
}
\arguments{
\item{md}{a matrix_data or md_tbl object or any can be converted to matrix_data.}

\item{mapping}{default list of aesthetic mappings to use for plot.}

\item{drop}{logical. If TRUE, the unused labels will be removed.}

\item{parse}{logical or function generated by \code{parse_func()}.}

\item{facets}{a parameters list of \code{facet_wrap}.}

\item{facets_order}{character vector to set the order of facet panels.}

\item{use_md}{deprecated.}

\item{...}{passing to \code{\link{as_matrix_data}}.}
}
\value{
a ggplot object.
}
\description{
Initialize a new hyplot
}
\examples{
library(ggplot2)
hyplot(mtcars) +
  geom_tile(aes(fill = mtcars))
}
\author{
Hou Yun
}
