% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-mark.R
\name{geom_mark}
\alias{geom_mark}
\title{Significant Marks}
\usage{
geom_mark(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  nudge_x = 0,
  nudge_y = 0,
  digits = 2,
  nsmall = 2,
  only_mark = FALSE,
  sig_level = c(0.05, 0.01, 0.001),
  mark = c("*", "**", "***"),
  sig_thres = NULL,
  sep = "",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{digits}{integer indicating the number of decimal places (round) or
significant digits (signif) to be used, the default value is 2.}

\item{nsmall}{the minimum number of digits to the right of the decimal
point in formatting real/complex numbers in non-scientific formats,
the default value is 2.}

\item{only_mark}{if TRUE, only the significant marks add on the plot.}

\item{sig_level}{significance level，the default values is [0.05, 0.01, 0.001].}

\item{mark}{significance mark，the default values is ["*", "**", "***"].}

\item{sig_thres}{if not NULL, just when pvalue is not larger than sig_thres will be ploted.}

\item{sep}{a character string to separate the number and mark symbols.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
layer function to add significant marks on a plot.
}
\section{Aesthetics}{

    \code{geom_mark()} understands the following aesthetics (required
    aesthetics are in bold):
    \itemize{
      \item \strong{\code{x}}
      \item \strong{\code{y}}
      \item \strong{\code{pvalue}}
      \item \code{r}
      \item \code{alpha}
      \item \code{colour}
      \item \code{size}
      \item \code{angle}
      \item \code{hjust}
      \item \code{vjust}
      \item \code{family}
      \item \code{fontface}
      \item \code{lineheight}
   }
}

\examples{
correlate(mtcars) \%>\%
  qcorrplot() + geom_mark()
}
