% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-annotate.R
\name{geom_annotate}
\alias{geom_annotate}
\alias{annotateGrob}
\alias{annotateGrob.grob}
\alias{annotateGrob.character}
\alias{annotateGrob.raster}
\alias{annotateGrob.magick-image}
\alias{annotateGrob.ggplot}
\alias{annotateGrob.NULL}
\alias{annotateGrob.numeric}
\title{Annotate Layer}
\usage{
geom_annotate(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "rt",
  show.legend = FALSE,
  ...,
  annotate = NULL,
  width = NULL,
  height = NULL,
  recycle = FALSE,
  na.rm = FALSE
)

annotateGrob(annotate, ...)

\method{annotateGrob}{grob}(
  annotate,
  position = "rt",
  width = NULL,
  height = NULL,
  nudge_x = 0,
  nudge_y = 0,
  default.units = "npc",
  ...
)

\method{annotateGrob}{character}(
  annotate,
  position = "rt",
  hjust = 0.5,
  vjust = 0.5,
  width = NULL,
  height = NULL,
  nudge_x = 0,
  nudge_y = 0,
  default.units = "npc",
  parse = FALSE,
  ...
)

\method{annotateGrob}{raster}(
  annotate,
  position = "rt",
  width = 0.5,
  height = 0.5,
  nudge_x = 0,
  nudge_y = 0,
  default.units = "npc",
  ...
)

\method{annotateGrob}{`magick-image`}(
  annotate,
  position = "rt",
  width = 0.5,
  height = 0.5,
  nudge_x = 0,
  nudge_y = 0,
  default.units = "npc",
  ...
)

\method{annotateGrob}{ggplot}(
  annotate,
  position = "rt",
  width = 0.5,
  height = 0.5,
  nudge_x = 0,
  nudge_y = 0,
  default.units = "npc",
  ...
)

\method{annotateGrob}{`NULL`}(annotate, ...)

\method{annotateGrob}{numeric}(annotate, digits = 2, nsmall = 2, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{string, position of annotate:
 \itemize{
   \item{\code{"rt"}: right-top corner.}
   \item{\code{"rb"}: right-bottom corner.}
   \item{\code{"rc"}: right-center.}
   \item{\code{"lt"}: left-top corner.}
   \item{\code{"lb"}: left-bottom corner.}
   \item{\code{"lc"}: left-center.}
   \item{\code{"cc"}: center-center.}
   \item{\code{"ct"}: center-top.}
   \item{\code{"cb"}: center-bottom.}
}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{...}{other parameters passing to convert-function.}

\item{annotate}{a grob object, or other object can be converted to a grob.}

\item{width, height}{width/height of annotate.}

\item{recycle}{if TRUE indicating annotate will repeated to the same length
as rows of data.}

\item{na.rm}{not used.}

\item{nudge_x, nudge_y}{a minor shift of position, should be a grid::unit object.}

\item{default.units}{A string indicating the default units to use.}

\item{hjust, vjust}{a numeric vector specifying horizontal/vertical justification.}

\item{parse}{if TRUE (default) will convert text to richtext.}

\item{digits}{integer indicating the number of decimal places (round)
to be used, the default value is 2.}

\item{nsmall}{the minimum number of digits to the right of the decimal point,
the default value is 2.}
}
\value{
a layer object.
}
\description{
A wrapper funtion to add some annotate elements on ggplot.
}
\author{
Hou Yun
}
