% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-utils.R
\name{element_formula}
\alias{element_formula}
\title{Theme element that enables formula}
\usage{
element_formula(
  parse = TRUE,
  family = NULL,
  face = NULL,
  size = NULL,
  colour = NULL,
  hjust = NULL,
  vjust = NULL,
  angle = NULL,
  lineheight = NULL,
  margin = NULL,
  color = NULL,
  debug = FALSE,
  inherit.blank = FALSE
)
}
\arguments{
\item{parse}{logical or a parse function. IF TRUE (default), the labels will
be parsed into expression.}

\item{family}{Font family}

\item{face}{Font face ("plain", "italic", "bold", "bold.italic")}

\item{size}{Line/border size in mm; text size in pts.}

\item{colour, color}{Line/border colour. Color is an alias for colour.}

\item{hjust}{Horizontal justification (in \eqn{[0, 1]})}

\item{vjust}{Vertical justification (in \eqn{[0, 1]})}

\item{angle}{Angle (in \eqn{[0, 360]})}

\item{lineheight}{Line height}

\item{margin}{Margins around the text. See \code{\link[ggplot2:margin]{margin()}} for more
details. When creating a theme, the margins should be placed on the
side of the text facing towards the center of the plot.}

\item{debug}{If \code{TRUE}, aids visual debugging by drawing a solid
rectangle behind the complete text area, and a point where each label
is anchored.}

\item{inherit.blank}{Should this element inherit the existence of an
\code{element_blank} among its parents? If \code{TRUE} the existence of
a blank element among its parents will cause this element to be blank as
well. If \code{FALSE} any blank parent element will be ignored when
calculating final element state.}
}
\value{
a element_magic_text object.
}
\description{
theme element that can parse text to expression or richtext.
}
\author{
Hou Yun
}
