% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate.R, R/deprecated.R
\name{correlate}
\alias{correlate}
\alias{print.correlate}
\alias{print.grouped_correlate}
\alias{fast_correlate}
\alias{fast_correlate2}
\title{Correlate}
\usage{
correlate(
  x,
  y = NULL,
  group = NULL,
  method = "pearson",
  use = "everything",
  adjust = FALSE,
  adjust_method = "holm",
  engine = "default",
  ...
)

\method{print}{correlate}(x, all = FALSE, ...)

\method{print}{grouped_correlate}(x, all = FALSE, ...)

fast_correlate(...)

fast_correlate2(...)
}
\arguments{
\item{x, y}{a matrix object or NULL.}

\item{group}{NULL or a character vector.}

\item{method}{a character string indicating which correlation coefficient
is to be used
for the test. One of "pearson", "kendall", or "spearman".}

\item{use}{an optional character string giving a method for computing
covariances in the presence of missing values.}

\item{adjust}{logical, if TRUE (default) will adjust p value for multiple
comparisons.}

\item{adjust_method}{correction method.}

\item{engine}{one of "default", "WGCNA", "picante", "Hmisc" or "psych",
indicating which package is used to calculate the correlation.}

\item{...}{extra params passing to \code{print}.}

\item{all}{if FALSE (default) just print correlation matrix, else will
print all values.}
}
\value{
a list with correlation matrix, P values matrix, confidence intervals matrix.
}
\description{
Matrix of Correlations, P-values and confidence intervals
}
\details{
The columns of 'x' will be tested for each pair when y is NULL(the default),
otherwise each column in 'x' and each column in 'y' is tested for each pair.
}
\note{
`fast_correlate()` and `fast_correlate2()` has been deprecated in 0.0.4 version.
}
\examples{
correlate(mtcars)

m1 <- matrix(rnorm(100), nrow = 10)
m2 <- matrix(rnorm(60), nrow = 10)
correlate(m1, m2)

## adjust p value
correlate(m1, m2, adjust = TRUE)

## other package engine
\dontrun{
## use psych engine
correlate(m1, engine = "psych")

## use Hmisc engine
correlate(m1, engine = "Hmisc")

## use WGCNA engine
correlate(m1, m2, engine = "WGCNA")

## use picante engine
correlate(m1, engine = "picante")
}
m <- correlate(mtcars, cor.test = TRUE)
print(m)
print(m, TRUE)
}
\seealso{
\code{\link[stats]{cor}}, \code{\link[stats]{cor.test}}.
}
\author{
Hou Yun
}
