% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-relimp.R
\name{calc_relimp}
\alias{calc_relimp}
\alias{print.calc_relimp}
\title{Relative importance}
\usage{
calc_relimp(
  spec,
  env,
  type = "lmg",
  family = gaussian,
  na.action = na.exclude,
  byrow = TRUE,
  ...
)

\method{print}{calc_relimp}(x, ...)
}
\arguments{
\item{spec, env}{a data.frame object.}

\item{type}{one of "lmg", "last", "first", "betasq", "pratt", "genizi" or "car".}

\item{family}{a link function to be used in the model, see \code{\link[stats]{family}}.}

\item{na.action}{a function which indicates what should happen when the data contain NAs.}

\item{byrow}{a logical value, if TRUE, the 'spec' on the rows.}

\item{...}{extra parameters.}

\item{x}{a calc_relimp object.}
}
\value{
a calc_relimp object.
}
\description{
Relative importance
}
\examples{
\dontrun{
spec <- mtcars[c(1, 3, 4, 5)]
env <- mtcars[6:11]
calc_relimp(spec, env)
}
}
\author{
Hou Yun
}
