function Buildexe(appname, exclList, inclList, flags)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% BuildExe allows building of the current directories project in 
% without having to change the output directory or update the .m 
% files list, every time (as seems to be the case with deploytool)
%
% Also it finds all the .m files under the current directory 
%

rootdir = filesepStandard(pwd);

% Args 
if ~exist('appname','var')
    [~, appname] = fileparts(rootdir);
end
if ~exist('exclList','var')
    exclList = {};
end
if ~exist('inclList','var')
    inclList = {};
end
if ~exist('flags','var')
    flags = {};
end

rootdir = filesepStandard(fileparts(which(appname)));


% Matlab compiler generates a readme file that overwrites the app readme
% that already xists. Before we start build , move readme to temp file and 
% at end of build delete the newly generated readme and move the temp one 
% back. 
if ispathvalid('./README.txt', 'file')
    movefile('./README.txt', 'TEMP.txt');
end

appDotMFileMain = [appname, '.m'];
appDotMFilesStr = sprintf('-v %s', appDotMFileMain');

% Get all .m files which will go into making the app executable
appDotMFiles = findDotMFiles(rootdir, exclList);
appDotMFiles = [appDotMFiles; inclList];


% Create compile switches string
compileSwitches = '';
for ii = 1:length(flags)
    compileSwitches = [compileSwitches, flags{ii}, ' ']; %#ok<*AGROW>
end
compileSwitches = [compileSwitches, ' -w enable:specified_file_mismatch'];
compileSwitches = [compileSwitches, ' -w enable:repeated_file'];
compileSwitches = [compileSwitches, ' -w enable:switch_ignored'];
compileSwitches = [compileSwitches, ' -w enable:missing_lib_sentinel'];
compileSwitches = [compileSwitches, ' -w enable:demo_license'];

%%% Go through all the apps, contruct a string listing all the .m files 
%%% on which each app depends and then compile the app using mcc.


% Remove main m file and remove Buildme.m from app files list 
appDotMFiles = removeEntryFromList(appDotMFileMain, appDotMFiles);
appDotMFiles = removeEntryFromList('Buildme.m', appDotMFiles);

% Construct files list portion of build command
fid = fopen('./Buildme.log','w');
fprintf(fid, '==================================:\n');
fprintf(fid, 'Building %s from these files:\n', appname);
fprintf(fid, '==================================:\n');
for jj = 2:length(appDotMFiles)
    appDotMFilesStr = sprintf('%s -a ''%s''', appDotMFilesStr, appDotMFiles{jj});
    fprintf(fid, '%s\n', appDotMFiles{jj});
end
fprintf(fid, '\n\n');
fclose(fid);

% Complete the final build command and execute it
buildcmdstr = sprintf('mcc -o %s -W main:%s -T link:exe -d ''%s'' %s %s', appname, appname, rootdir, compileSwitches, appDotMFilesStr);
disp(buildcmdstr);
eval(buildcmdstr);

% Delete useless readme generated by mcc and replace it with our own
% readme.txt that already exsisted
if ispathvalid('./README.txt', 'file')
    delete('./README.txt');
end
if ispathvalid('./TEMP.txt', 'file')
    movefile('TEMP.txt','./README.txt');
end





