source $1

ls ${work_dir}/*.fastq | while read i
do
    name=$(basename $i .fastq | sed 's/_read[1-2]//g')
    sample=$(echo $name | \
    		sed 's/_rep[0-9]*//g' | \
    		sed 's/_t[0-9]*//g' | \
    		sed 's/_part[0-9]*//g' | \
    		sed 's/_read[1-2]//g')
    read_str=$(basename $i .fastq | sed "s/${name}_//g")

    sample_dir=${work_dir}/${sample}
    fastq_dir=${work_dir}/fastq

    if [ ! -d $sample_dir ];then
        mkdir -p ${sample_dir}/fastq
        mkdir -p ${sample_dir}/splits
    fi

    if [ ! -d $fastq_dir ];then
        mkdir $fastq_dir
    fi

    script_name=${name}_${read_str}_slice
    script_sh=${script_name}.sh

    if [ $cluster == "qiming" ];then
        echo -e "#PBS -S /bin/bash
                 #PBS -V
                 #PBS -q ser
                 #PBS -l nodes=1:ppn=slice_core
                 #PBS -m a
                 #PBS -j oe
                 #PBS -N Job_name" > $script_sh
    elif [ $cluster == "taiyi" ];then
        echo -e '#!/bin/sh
                #BSUB -J Job_name
                #BSUB -q ser
                #BSUB -n slice_core
                #BSUB -R "span[ptile=40]"' > $script_sh
    fi

    sed -i 's/^[[:space:]]*//g' $script_sh
    sed -i "s/Job_name/$script_name/g" $script_sh
    sed -i "s/slice_core/$slice_core/g" $script_sh

    echo -e    "\n\
            \nsplit -a 4 \\\
                \n\t-l $slice_size \\\
                \n\t-d \\\
                \n\t--additional-suffix=_${read_str}.fastq \\\
                \n\t$i \\\
                \n\t${sample_dir}/fastq/${name}_slice\
            \n\
            \nmv $i ${work_dir}/fastq\
            \n" >> $script_sh

    sed -i 's/[[:space:]]*$//g' $script_sh
	if [ $2 -eq 1 ];then
    	if [ $cluster == "qiming" ];then
    		qsub $script_sh
    	elif [ $cluster == "taiyi" ];then
        	bsub < $script_sh
    	fi
	    /bin/rm -rf $script_sh
	fi
done
