work_dir=$(pwd)
cluster=taiyi
slice_size=2000000
genome_version=hg19
enzyme=DpnII
libraries=(DMSO_DHT)
juicer_dir=~/local/chaos.juicer
bwa_cmd=~/conda/envs/basic_software/bin/bwa
samtools_cmd=~/conda/envs/basic_software/bin/samtools
awk_cmd=~/conda/envs/basic_software/bin/awk
pigz_cmd=~/conda/envs/basic_software/bin/pigz

##=====threads======
slice_core=1
align_core=5
hic_generation_core=5
local_threads=$(cat /proc/cpuinfo| grep "processor"| wc -l)

##======no need to modify==========
common_dir=${juicer_dir}/common
hic_tools=${common_dir}/hic_tools
reference_dir=~/Data/Reference/${genome_version}
bwa_index=${reference_dir}/bwa_index/${genome_version}.fa
site_file=${reference_dir}/annotation/${genome_version}_${enzyme}.txt
genome_size_file=${reference_dir}/annotation/${genome_version}.size.1
res_calc_cmd="sh ${juicer_dir}/misc/calculate_map_resolution.sh"

if   [ $enzyme == "DpnII" ];then
	ligation=GATCGATC
elif [ $enzyme == "HindIII" ];then
	ligation=AAGCTAGCTT
elif [ $enzyme == "MboI" ];then
	ligation=GATCGATC
fi
