source $1

n_sh=1
for library in ${libraries[*]}
do
	script_name=${library}_generate_hic
	script_sh=${script_name}.sh

	if [ $cluster == "qiming" ];then
		echo -e "#PBS -S /bin/bash
					#PBS -V
					#PBS -q ser
					#PBS -l nodes=1:ppn=hic_generation_core
					#PBS -m ae
					#PBS -j oe
					#PBS -N Job_name" > $script_sh
	elif [ $cluster == "taiyi" ];then
		echo -e '#!/bin/sh
				#BSUB -J Job_name
				#BSUB -q ser
				#BSUB -n hic_generation_core
				#BSUB -R "span[ptile=40]"' > $script_sh
	fi

	sed -i 's/^[[:space:]]*//g' $script_sh
	sed -i "s/Job_name/$script_name/g" $script_sh
	sed -i "s/hic_generation_core/$hic_generation_core/g" $script_sh

	library_dir=${work_dir}/${library}
	split_dir=${library_dir}/splits
	out_dir=${library_dir}/result
	out_prefix=${out_dir}/${library}
	tmp_dir=${library_dir}/HIC_tmp

	thread_str=$(echo $hic_generation_core*2 | bc)
	norm_list=({,GW_,INTER_}{KR\,,SCALE\,,VC\,} VC_SQRT)
	merged_bam=${out_prefix}_merged_sort.bam
	merged_dedup_prefix=${out_prefix}_merged_dedup
	merged_dedup_sam=${out_prefix}_merged_dedup.sam
	merged_dedup_txt=${out_prefix}_merged_dedup.txt
	merged_dedup_index_txt=${out_prefix}_merged_dedup_index.txt
	merged_dedup_bam=${out_prefix}_merged_dedup.bam
	stat_txt=${out_prefix}_inter.txt
	stat_m=${out_prefix}_inter_hists.m

	if [ ! -d $out_dir ];then mkdir $out_dir;fi
	if [ ! -d $tmp_dir ];then mkdir $tmp_dir;fi

	echo -e \
	"\n\
	\nif [ ! -e $merged_bam ];then\
		\n\t$samtools_cmd \\\
			\n\t\tmerge \\\
				\n\t\t\t-c \\\
				\n\t\t\t-t cb \\\
				\n\t\t\t-n \\\
				\n\t\t\t-@ $thread_str \\\
				\n\t\t\t$merged_bam \\\
				\n\t\t\t${split_dir}/*.bam \
	\nfi\
	\n\
	\nif [ ! -e $merged_dedup_sam ];then\
		\n\t$samtools_cmd \\\
			\n\t\tview \\\
				\n\t\t\t-@ $thread_str \\\
				\n\t\t\t-h $merged_bam | \\\
		\n\t$awk_cmd \\\
			\n\t\t-f ${common_dir}/dups_sam.awk \\\
		\n\t> $merged_dedup_sam \
	\nfi\
	\n\
	\nif [ ! -e $merged_dedup_txt ];then\
		\n\t$samtools_cmd \\\
			\n\t\tview \\\
				\n\t\t\t-@ $thread_str \\\
				\n\t\t\t-F 1024 \\\
				\n\t\t\t-O sam \\\
				\n\t\t\t$merged_dedup_sam | \\\
		\n\t$awk_cmd \\\
			\n\t\t-v mapq=1 \\\
			\n\t\t-f ${common_dir}/sam_to_pre.awk \\\
		\n\t> $merged_dedup_txt \
	\nfi\
	\n\
	\nif [ ! -e $merged_dedup_index_txt ];then\
		\n\t${common_dir}/index_by_chr.awk \\\
			\n\t\t$merged_dedup_txt \\\
			\n\t\t500000 \\\
		\n\t> $merged_dedup_index_txt \
	\nfi\
	\n\
	\nif [ ! -e $merged_dedup_bam ];then\
		\n\t$samtools_cmd \\\
			\n\t\tview \\\
				\n\t\t\t-b \\\
				\n\t\t\t-@ $thread_str \\\
				\n\t\t\t$merged_dedup_sam \\\
		\n\t> $merged_dedup_bam \
	\nfi\
	\n\
	\nrm $merged_dedup_sam \
	\n\
	\nexport IBM_JAVA_OPTIONS=\"-Xmx60g -Xgcthreads${thread_str}\"\
	\nexport _JAVA_OPTIONS=\"-Xmx60g -Xms60g\"\
	\n\
	\nif [ ! -e $stat_m ];then\
		\n\tdups=\$(\\\
			\n\t\t$samtools_cmd \\\
				\n\t\t\tview \\\
					\n\t\t\t\t-c \\\
					\n\t\t\t\t-f 1089 \\\
					\n\t\t\t\t-F 256 \\\
					\n\t\t\t\t-@ $thread_str \\\
					\n\t\t\t\t$merged_dedup_bam\\\
		\n\t) \
		\n\
		\n\tcat \\\
			\n\t\t${split_dir}/*.res.txt | \\\
		\n\t$awk_cmd \\\
			\n\t\t-v dups=\$dups \\\
			\n\t\t-v ligation=$ligation \\\
			\n\t\t-f ${common_dir}/stats_sub.awk \\\
		\n\t> $stat_txt \
		\n\t\
		\n\t$hic_tools \\\
			\n\t\tstatistics \\\
				\n\t\t\t--threads $thread_str \\\
				\n\t\t\t$site_file \\\
				\n\t\t\t$stat_txt\\\
				\n\t\t\t$merged_dedup_txt \\\
				\n\t\t\t$genome_size_file \
		\n\
	\nfi\
	\n\
	\n$hic_tools \\\
		\n\tpre \\\
			\n\t\t--threads $thread_str \\\
			\n\t\t-s $stat_txt \\\
			\n\t\t-g $stat_m \\\
			\n\t\t-i $merged_dedup_index_txt \\\
			\n\t\t-t $tmp_dir \\\
			\n\t\t$merged_dedup_txt \\\
			\n\t\t${out_prefix}.hic \\\
			\n\t\t$genome_size_file \
	\n" >> $script_sh

	sed -i 's/[[:space:]]*$//g' $script_sh
	sed -i 's/, /,/g' $script_sh
	if [ $2 -eq 1 ];then
		if [ $cluster == "qiming" ];then
			qsub $script_sh
		elif [ $cluster == "taiyi" ];then
			bsub < $script_sh
		fi
		/bin/rm -rf $script_sh
		echo "You've submitted $n_sh jobs"
		n_sh=$(echo $n_sh +1 | bc)
	fi
done
