#PBS -S /bin/bash
#PBS -q cal-s
#PBS -l nodes=1:ppn=24
#PBS -m a
#PBS -j oe
#PBS -N example


source /home/bio-fangc/local/juicer/hic_essential_files/environment.sh

/home/bio-fangc/local/juicer/juicer.sh -d ${work_folder}/experiment/example -g hg19

ls ${work_folder}/experiment/example/aligned | while read i
do 
	mv ${work_folder}/experiment/example/aligned/${i} ${work_folder}/experiment/example/aligned/example_${i}
	mv ${work_folder}/experiment/example/fastq/${i} ${work_folder}/experiment/example/fastq/example_${i}
done


gtz ${work_folder}/experiment/example/aligned/example_merged_sort.txt
gtz ${work_folder}/experiment/example/aligned/example_merged_nodups.txt
gtz ${work_folder}/experiment/example/aligned/example_opt_dups.txt
gtz ${work_folder}/experiment/example/aligned/example_dups.txt
gtz ${work_folder}/experiment/example/aligned/example_collisions_nodups.txt
gtz ${work_folder}/experiment/example/aligned/example_collisions.txt
samtools view -bT /home/bio-fangc/Data/Reference/UCSC_hg19/hg19 ${work_folder}/experiment/example/aligned/example_abnormal.sam > ${work_folder}/experiment/example/aligned/example_abnormal.bam @ 24
samtools view -bT /home/bio-fangc/Data/Reference/UCSC_hg19/hg19 ${work_folder}/experiment/example/aligned/example_unmapped.sam > ${work_folder}/experiment/example/aligned/example_unmapped.bam @ 24
/bin/rm -rf ${work_folder}/experiment/example/aligned/example_merged_sort.txt
/bin/rm -rf ${work_folder}/experiment/example/aligned/example_merged_nodups.txt
/bin/rm -rf ${work_folder}/experiment/example/aligned/example_opt_dups.txt
/bin/rm -rf ${work_folder}/experiment/example/aligned/example_dups.txt
/bin/rm -rf ${work_folder}/experiment/example/aligned/example_collisions_nodups.txt
/bin/rm -rf ${work_folder}/experiment/example/aligned/example_collisions.txt
/bin/rm -rf ${work_folder}/experiment/example/aligned/*.sam
gtz --ref /home/bio-fangc/Data/Reference/UCSC_hg19_gtz/hg19 --cache-path /home/bio-fangc/.config/gtz ${work_folder}/experiment/example/fastq/example_R1.fastq
gtz --ref /home/bio-fangc/Data/Reference/UCSC_hg19_gtz/hg19 --cache-path /home/bio-fangc/.config/gtz ${work_folder}/experiment/example/fastq/example_R2.fastq
/bin/rm -rf ${work_folder}/experiment/example/fastq/*.fastq
/bin/rm -rf ${work_folder}/experiment/example/splits

