#PBS -S /bin/bash
#PBS -q cal-s
#PBS -l nodes=1:ppn=24
#PBS -m a
#PBS -j oe
#PBS -N juicer_post

source /home/bio-fangc/local/juicer/hic_essential_files/environment.sh

mkdir ${analysis_folder}
mkdir ${hic_folder}
mkdir ${correlation_folder}
mkdir ${cool_folder}
mkdir ${h5_folder}
mkdir ${hicexplorer_tad_folder}
mkdir ${hicexplorer_tad_data_folder}
mkdir ${hicexplorer_tad_overlap_folder}
mkdir ${arrowhead_tad_folder}
mkdir ${eigenvector_folder}
mkdir ${eigenvector_corrected_folder}
mkdir ${3dgenome_loop_folder}
mkdir ${hiccups_loop_folder}
mkdir ${DistVsCounts_folder}
mkdir ${SVL_folder}
mkdir ${Whole_Chromosome_Positioning_Analysis_folder}
mkdir ${inter_matrix_NONE_folder}
mkdir ${intra_matrix_NONE_folder}

cat $sample_all_list | while read i
 do
 	/bin/rm -rf ${experiment_folder}/${i}/splits
 	ls ${experiment_folder}/${i}/aligned | while read j
 	do
 		mv ${experiment_folder}/${i}/aligned/${j} ${experiment_folder}/${i}/aligned/${i}_${j}
 	done
 	cp ${experiment_folder}/${i}/aligned/${i}_inter.hic ${analysis_folder}/hic_files/${i}.hic
 done 
 Rscript ${hic_essential_files}/hic_info_generation.R
 cat $sample_all_list | while read i
 do
	gtz ${experiment_folder}/${i}/aligned/${i}_${j}_merged_sort.txt
	gtz ${experiment_folder}/${i}/aligned/${i}_${j}_merged_nodups.txt
	gtz ${experiment_folder}/${i}/aligned/${i}_${j}_opt_dups.txt
	gtz ${experiment_folder}/${i}/aligned/${i}_${j}_dups.txt
	gtz ${experiment_folder}/${i}/aligned/${i}_${j}_collisions_nodups.txt
	gtz ${experiment_folder}/${i}/aligned/${i}_${j}_collisions.txt
	samtools view -Sb ${experiment_folder}/${i}/aligned/${i}_${j}_abnormal.sam > ${experiment_folder}/${i}/aligned/${i}_${j}_abnormal.bam @ 24
	samtools view -Sb ${experiment_folder}/${i}/aligned/${i}_${j}_unmapped.sam > ${experiment_folder}/${i}/aligned/${i}_${j}_unmapped.bam @ 24
	/bin/rm -rf ${experiment_folder}/${i}/aligned/${i}_${j}_merged_sort.txt
	/bin/rm -rf ${experiment_folder}/${i}/aligned/${i}_${j}_merged_nodups.txt
	/bin/rm -rf ${experiment_folder}/${i}/aligned/${i}_${j}_opt_dups.txt
	/bin/rm -rf ${experiment_folder}/${i}/aligned/${i}_${j}_dups.txt
	/bin/rm -rf ${experiment_folder}/${i}/aligned/${i}_${j}_collisions_nodups.txt
	/bin/rm -rf ${experiment_folder}/${i}/aligned/${i}_${j}_collisions.txt
	/bin/rm -rf ${experiment_folder}/${i}/aligned/${i}_${j}_abnormal.sam
	/bin/rm -rf ${experiment_folder}/${i}/aligned/${i}_${j}_unmapped.sam
 done 
