source("/home/bio-fangc/local/juicer/hic_essential_files/environment.R",encoding = "UTF-8")

setwd(hic_folder)
library(reader)
library(tidyverse)

hic_info <- data.frame(c("Sequenced Read Pairs ","Normal Paired","Chimeric Paired",
						"Chimeric Ambiguou","Unmapped","Ligation Motif Present",
						"Alignable (Normal+Chimeric Paired)","Unique Reads",
						"PCR Duplicates","Optical Duplicates","Library Complexity Estimate",
						"Intra-fragment Reads","Below MAPQ Threshold","Hi-C Contacts",
						"Ligation Motif Present","3' Bias (Long Range)","Pair Type %(L-I-O-R)",
						"Inter-chromosomal","Intra-chromosomal","Short Range (<20Kb)","Long Range (>20Kb)"))

colnames(hic_info) <- "iterms"

inter_info <- hic_info
inter_30_info <- hic_info
sample_list <- read.table(sample_all_list)[,1]
chr_list <- paste("chr",read.table(chr_list_all)[,1],sep = "") 

for (sample in sample_list)
{
	inter_file <- paste(experiment_folder,"/",sample,"/aligned/",sample,"_inter.txt", sep = "")
	inter_30_file <- paste(experiment_folder,"/",sample,"/aligned/",sample,"_inter_30.txt", sep = "")
	a <- data.frame(n.readLines(inter_file,n = length(readLines(inter_file)))[c(1:7,10:23)])
	b <- data.frame(n.readLines(inter_30_file,n = length(readLines(inter_30_file)))[c(1:7,10:23)])
	colnames(a) <- "tmp"
	colnames(b) <- "tmp"
	a <- separate(a,tmp, into = c("iterms",paste(sample,"_inter",sep = "")),sep = ":")
	b <- separate(b,tmp, into = c("iterms",paste(sample,"_inter_30",sep = "")),sep = ":")
	a1 <- data.frame(a[,2])
	b1 <- data.frame(b[,2])
	colnames(a1) <- paste(sample,"_inter",sep = "")
	colnames(b1) <- paste(sample,"_inter_30",sep = "")
	inter_info <- cbind(inter_info,a1)
	inter_30_info <- cbind(inter_30_info,b1)
}

write.table(inter_info, "hic_info_inter.txt", row.names = F, col.names = T, quote = F, sep = "\t")
write.table(inter_30_info, "hic_info_inter_30.txt", row.names = F, col.names = T, quote = F, sep = "\t")


