pacman::p_load(tidyfst)

args <- commandArgs(T)

sample <- args[1]

chr <- args[2]

resolution <- as.numeric(args[3])

file <- paste0(sample,"_",chr,"_",resolution,"k.txt")

raw_matrix <- fread(file)

bin_min <- resolution * 1000
bin_max <- max(raw_matrix$V1,raw_matrix$V2)
model <- expand.grid(seq(bin_min,bin_max,bin_min),seq(bin_min,bin_max,bin_min)) %>% data.table()

new_format <- left_join_dt(
                  model,
                  raw_matrix,
                  by = c("Var1" =  "V1", "Var2" = "V2")
              ) %>%
              wider_dt(Var1, name = "Var2", value = "V3") %>%
              replace_na_dt(to = 0) %>%
			  select_dt(-1)
write.table(
  new_format,
  paste0(sample,"_",chr,"_",resolution,"k_for_topdom.txt"),
  col.names = F,
  row.names = F,
  quote = F,
  sep = "\t"
)
