source("/home/bio-fangc/local/juicer/hic_essential_files/environment.R",encoding = "UTF-8")

setwd(eigenvector_corrected_folder)

chr_list <- paste("chr",read.table(chr_list_all)[,1],sep = "")
resolution_list <- as.character(read.table(resolution_list_eigenvector)[,1])
sample_list <- as.character(read.table(sample_without_rep_list)[,1])

for (r in resolution_list)
{
	a <- read.table(paste(r,"k/average_gene_density_",r,"k.txt",sep = ""))
	a[,1] <- as.character(a[,1])
	library(dplyr)
	a <- filter(a, V11 < 0)
	write.table(a, paste(r,"k/corrected_files_info.txt", sep = ""), col.names = F, row.names = F, quote = F, sep = "\t")
	for (i in a[,1])
	{
		b <- read.table(paste(r,"k/",i,sep = ""))
		b <- b*(-1)
		write.table(b, paste(r,"k/",i,sep = ""), row.names = F, col.names = F)
	}
}


for (r in resolution_list)
{
	for (s in sample_list)
	{
		for (c in chr_list)
		{
			genome_size <- read.table(genome_size_file)
			chr_size <- genome_size[which(genome_size[,1] == c),2]
			file <- paste(eigenvector_corrected_folder,"/",r,"k/",s,"_",c,"_eigenvector_KR_",r,"k",sep = "")
			a <- read.table(file)
			a[,2] <- c
			a[,3] <- as.character(format(seq(0,(nrow(a)-1)*as.numeric(r)*1000,as.numeric(r)*1000),scientific = F))
			a[,4] <- as.character(format(c(seq(as.numeric(r)*1000,chr_size,as.numeric(r)*1000),chr_size),scientific = F))
			b <- a[,c(2:4,1)]
			write.table(b,file,col.names = F, row.names = F, quote = F, sep = "\t")
		}
	}
}


