correlation_folder <- "/mnt/e/wsl_work/correlation/"

setwd(correlation_folder)

library(pdftools)
library(tidyverse)
library(pheatmap)
library(readr)

sample_all <- read.table("../sample_all_list")[,1]
sample_rep <- read.table("../sample_without_rep_list")[,1]
sample_merge <- read.table("../sample_without_merge_list")[,1]
pdf <- list.files(getwd(), pattern = "heatmap.pdf")

##=========================pdf OCR==============================================

for (i in pdf)
{
	text <- pdf_text(i) %>% read_lines()
	start <- length(text) - length(sample_all)
	end <- length(text) - 1
	data <- data.frame(text[start:end])
	colnames(data) <- NULL
	name <- paste(strsplit(i,"[.]")[[1]][1],".data", sep = "")
	write.table(data,name,quote=F,sep="\t", row.names = F)
}

##=========================rewrite the data files===============================

data_list <- list.files(getwd(), pattern = ".data")
for (j in data_list)
{
	a <- read.table(j)
	a[,ncol(a)] <- as.character(a[,ncol(a)])
	colnames(a)[ncol(a)] <- "tmp"
	a <- separate(a,tmp, into = c("tmp1","tmp2"),sep = "_KR_")
	a <- a[,1:ncol(a)-1]
	b <- a[,1:ncol(a)-1]
	rownames(b) <- a[,ncol(a)]
	colnames(b) <- rev(a[,ncol(a)])
	b <-b[sample_all,rev(sample_all)]
	write.table(b,j,quote=F, sep="\t", row.names = T, col.names = T)
}

##=========================replot the correlation files==========================

for (j in data_list)
{
	b <- read.table(j,header = T, row.names = 1)
	c <- b[which(rownames(b) %in% sample_merge),which(colnames(b) %in% sample_merge)]
	pdf_name <- paste(strsplit(j,"[.]")[[1]][1],"replot.pdf",sep = "_")
	pdf(pdf_name)
	pheatmap(b, cluster_rows = F, cluster_cols = F,
         legend = T, main = strsplit(j,"[.]")[[1]][1],
         display_numbers = T, fontsize = 6, fontsize_row = 12,
         fontsize_col = 12, number_color = "black",
         number_format = "%.2f", angle_col ="315",
         color = colorRampPalette(colors = c("steelblue","white","red"))(10000), border_color = "white")
    pheatmap(c, cluster_rows = F, cluster_cols = F,
         legend = T, main = strsplit(j,"[.]")[[1]][1],
         display_numbers = T, fontsize = 6, fontsize_row = 12,
         fontsize_col = 12, number_color = "black",
         number_format = "%.2f", angle_col ="315",
         color = colorRampPalette(colors = c("steelblue","white","red"))(10000), border_color = "white")
    dev.off()
}
