source /home/bio-fangc/local/my_script/3dgenome_script/environment.sh
source activate chromosight

sample_1="$1"
sample_2="$2"

# Sub-sampling: 
N1=$(cooler info $bank1_file | grep sum | awk '{print int($NF)}')
N2=$(cooler info $bank2_file | grep sum | awk '{print int($NF)}')
Nmin=$((( $N1 <= $N2 )) && echo "$N1" || echo "$N2")
echo 'Number of reads for both samples ( $sample_1 $sample_2 )'
echo $Nmin 
Nmin=$(($Nmin -1))
echo $Nmin 


cat $resolution_list_all | sed '1d' | while read resolution
do
	if [ ! -d ${chromosight_loop_folder}/${sample_1}_vs_${sample_2}_${resolution}k ];then
		mkdir ${chromosight_loop_folder}/${sample_1}_vs_${sample_2}_${resolution}k
	fi

	cd ${chromosight_loop_folder}/${sample_1}_vs_${sample_2}_${resolution}k
	
	sample_1_cool="${cool_folder}/${sample_1}_KR_${resolution}k.cool"
	sample_2_cool="${cool_folder}/${sample_2}_KR_${resolution}k.cool"
	
	sample_1_tsv="${chromosight_loop_folder}/${sample_1}_KR_${resolution}k_loop.tsv"
	sample_2_tsv="${chromosight_loop_folder}/${sample_2}_KR_${resolution}k_loop.tsv"
	
	echo "$sample_1 info:"
	echo "cool_file path: $sample_1_cool "
	echo "loop_file path: $sample_1_tsv "	
	echo "$sample_2 info:"
	echo "cool_file path: $sample_2_cool "
	echo "loop_file path: $sample_2_tsv "	

	if [ ! -f ${chromosight_loop_folder}/${sample_1}_vs_${sample_2}_${resolution}k/venn_diagram_group_loops_${sample_1}_#{sample_2}.pdf ];then
		python ${hic_essential_files}/common_loops_venn2.py "$sample_1_tsv" "$sample_1" "$sample_2_tsv" "$sample_2"
	fi
	
	if [ ! -f ${chromosight_loop_folder}/${sample_1}_vs_${sample_2}_${resolution}k/out_in_${sample_1}.group1.${sample_1}.pdf ];then
		chromosight quantify --threads 24 --subsample=$Nmin "group1_detected_in_${sample_1}.txt" "$sample_1_cool"  "out_in_${sample_1}.group1.${sample_1}"
	fi
	
	if [ ! -f ${chromosight_loop_folder}/${sample_1}_vs_${sample_2}_${resolution}k/out_in_${sample_1}.group2.${sample_2}.pdf ];then
		chromosight quantify --threads 24 --subsample=$Nmin "group2_detected_in_${sample_2}.txt" "$sample_1_cool"  "out_in_${sample_1}.group2.${sample_2}"
	fi
	
	if [ ! -f ${chromosight_loop_folder}/${sample_1}_vs_${sample_2}_${resolution}k/out_in_${sample_1}.group12.pdf ];then
		chromosight quantify --threads 24 --subsample=$Nmin "group12_detected_in_${sample_1}_${sample_2}.txt" "$sample_1_cool" "out_in_${sample_1}.group12"
	fi
	
	if [ ! -f ${chromosight_loop_folder}/${sample_1}_vs_${sample_2}_${resolution}k/out_in_${sample_2}.group1.${sample_1}.pdf ];then
		chromosight quantify --threads 24 --subsample=$Nmin "group1_detected_in_${sample_1}.txt" "$sample_2_cool"  "out_in_${sample_2}.group1.${sample_1}"
	fi
	
	if [ ! -f ${chromosight_loop_folder}/${sample_1}_vs_${sample_2}_${resolution}k/out_in_${sample_2}.group2.${sample_2}.pdf ];then
		chromosight quantify --threads 24 --subsample=$Nmin "group2_detected_in_${sample_2}.txt" "$sample_2_cool"  "out_in_${sample_2}.group2.${sample_2}"
	fi
	
	if [ ! -f ${chromosight_loop_folder}/${sample_1}_vs_${sample_2}_${resolution}k/out_in_${sample_2}.group12.pdf ];then
		chromosight quantify --threads 24 --subsample=$Nmin "group12_detected_in_${sample_1}_${sample_2}.txt" "$sample_2_cool" "out_in_${sample_2}.group12"
	fi
	
	
	pdfjam "out_in_${sample_1}.group1.${sample_1}.pdf" "out_in_${sample_2}.group1.${sample_1}.pdf"  --nup 2x1 --landscape --outfile all_pileups_g1.pdf
	# Same for group2
	pdfjam "out_in_${sample_1}.group2.${sample_2}.pdf" "out_in_${sample_2}.group2.${sample_2}.pdf"  --nup 2x1 --landscape --outfile all_pileups_g2.pdf
	# Same for intersection
	pdfjam "out_in_${sample_1}.group12.pdf"  "out_in_${sample_2}.group12.pdf" --nup 2x1 --landscape --outfile all_pileups_g12.pdf
	# Combine all pileups into a single pdf
	pdfjam all_pileups_g1.pdf all_pileups_g12.pdf all_pileups_g2.pdf --nup 6x1 --landscape --outfile "all_pileups_${sample_1}.${sample_2}.pdf"
	pdfjam "all_pileups_${sample_1}.${sample_2}.pdf" "venn_diagram_group_loops_${sample_1}_${sample_2}.pdf" --nup 1x2  --outfile "final_${sample_1}.${sample_2}.pdf"
	
	echo "${sample_1}_vs_${sample_2}_${resolution}k is finished! "

done
