#!/bin/bash
# pipeline to calculate insulation score (KR normalized)
# input : hicfile resolusion threads_number
# need exec file straw in your path

hic_file=$1
chr=$2
res=$3
threads=$4
out_dir=$5

block_size=40

juicer_dir=/work/bio-fangc/local/juicer
insulation_score_dir=${juicer_dir}/hic_essential_files/calc_IS

name=$(basename $hic_file .hic)


echo "fixedStep chrom=${chr} start=1 step="${res}" span="${res} > ${out_dir}/${name}.${chr}.${res}.IS.wig

${juicer_dir}/straw KR $hic_file $chr $chr BP $res | \
	parallel --pipe -j $threads ${insulation_score_dir}/calc_insulation_worker.awk -v block_size=$block_size -v res=${res} | \
	${insulation_score_dir}/calc_insulation_merge.awk >> ${out_dir}/${name}.${chr}.${res}.IS.wig

#cat ${out_dir}/${name}.*.IS.wig > ${out_dir}/${name}.all.IS.wig

#for chr in ${chrList[*]}
#do
#    rm ${name}.${chr}.insulation.wig
#done

