#!/bin/bash
# pipeline to calculate DI index (KR normalized)
# input : hicfile resolusion threads_number
# need exec file straw in your path

hic_file=$1
chr=$2
res=$3
threads=$4
out_dir=$5

block_size=40


juicer_dir=/work/bio-fangc/local/juicer
calc_DI_dir=${juicer_dir}/hic_essential_files/calc_DI

name=$(basename $hic_file .hic)



echo "fixedStep chrom=$chr start=1 step="${res}" span="${res} > ${out_dir}/${name}.${chr}.${res}.DI.wig

${juicer_dir}/straw KR $hic_file $chr $chr BP $res | \
	parallel --pipe -j $threads ${calc_DI_dir}/calc_DI_worker.awk -v block_size=${block_size} -v res=${res} | \
	${calc_DI_dir}/calc_DI_merge.awk >> ${out_dir}/${name}.${chr}.${res}.DI.wig


#cat ${out_dir}/${name}.*.DI.wig > ${out_dir}/${name}.all.DI.wig

#for chr in ${chrList[*]}
#do
#    rm ${name}.${chr}.DI.wig
#done
