source("/home/bio-fangc/local/juicer/hic_essential_files/environment.R",encoding = "UTF-8")

library(dplyr)
library(pheatmap)
library(tidyr)

setwd(Whole_Chromosome_Positioning_Analysis_folder)

sample_list <- read.table(sample_without_rep_list)[,1]
chr_list <- paste("chr",read.table(chr_list_all)[,1],sep = "") 

data_all <- data.frame(NULL)

normalization <- "NONE"
resolution <- "2500k"

for (sample in sample_list)
{
    for (i in chr_list)
    {
        for (j in chr_list)
        {
            if (i != j)
            {
                file <- paste(sample,i,j,"NONE_2500k_matrix.txt",sep = "_")
                a <- read.table(paste(inter_matrix_NONE_folder,file,sep = "/"))
                chr1 <- i
                chr2 <- j
                interactions <- sum(a[,3])
                b <- data.frame(sample,resolution,normalization,chr1,chr2,interactions)
                data_all <- rbind(data_all,b)
            }
        }
    }
}

write.table(data_all,"inter-chromsome_interaction_number.data", col.names = T, quote = F, sep = "\t")

v <- data_all

data <- data.frame(NULL)

for (sample in sample_list)
{
    sample_total_inter <- sum(v[which(v[,1] == sample),][,6])
    for (chr in chr_list)
    {
        chr_total_inter <- sum(v[which(v[,1] == sample & v[,4] == chr),][,6])
        normalization <- unique(v[,3])
        a <- data.frame(sample,resolution,normalization,chr,chr_total_inter,sample_total_inter) 
        data <- rbind(data,a)
    }
}

data1 <- data
colnames(data1)[4] <- "chr1"
colnames(data1)[5] <- "chr1_total_inter"
data2 <- data
colnames(data2)[4] <- "chr2"
colnames(data2)[5] <- "chr2_total_inter"

v <- left_join(v,data1,by=c("sample","resolution","normalization","chr1"))
v <- left_join(v,data2,by=c("sample","resolution","normalization","chr2","sample_total_inter"))

v <- v[,c(1:7,9,8)]

v[,10] <- v[,7]/v[,9]
colnames(v)[10] <- "chr1/total"

v[,11] <- v[,8]/(v[,9]-v[,7])
colnames(v)[11] <- "chr2/(total-chr1)"

v[,12] <- v[,8]/v[,9]
colnames(v)[12] <- "chr2/total"

v[,13] <- v[,7]/(v[,9]-v[,8])
colnames(v)[13] <- "chr1/(total-chr2)"

v[,14] <- v[,6]/((v[,10]*v[,11]+v[,12]*v[,13])*v[,9]/2)
colnames(v)[14] <- "Whole_Chromosome_Positioning_Analysis"


write.table(v,"Whole_Chromosome_Positioning_Analysis.txt",col.names = T, row.names = F, quote = F, sep= "\t")

v1 <- v[,c(1,2,4,5,14)]


heatmap <- data.frame(NULL)

for (sample in unique(v1[,1]))
{
    heatmap <- data.frame(NULL)
    for (chr in unique(v1[,3]))
    {
        a <- v1[which(v1[,1] == sample & v1[,3] == chr),]
        b <- t(a[,5])
        colnames(b) <- a[,4]
        rownames(b) <- a[1,3]
        insert <- data.frame(NA)
        colnames(insert) <- rownames(b)
        b <- cbind(b,insert)
        b <- b[,chr_list]
        heatmap <- rbind(heatmap,b)
    }
    file_name <- paste(sample,normalization,resolution,"Whole_Chromosome_Positioning_Analysis_heatmap_data.txt",sep = "_")
    write.table(heatmap,file_name,col.names =T, row.names = T, quote = F, sep= "\t")
}



files <- list.files(getwd(),"heatmap_data.txt")
for (i in files)
{
    heatmap <- read.table(i)
    pdf_name <- gsub("_data.txt",".pdf",i)
    pdf(pdf_name)
    pheatmap(heatmap, cluster_rows = F, cluster_cols = F,
         legend = T, main = paste(strsplit(i,"_")[[1]][1],strsplit(i,"_")[[1]][2],sep = "_"),
         display_numbers = T, fontsize = 6, fontsize_row = 12, fontsize_col = 12, number_color = "black",number_format = "%.1f",angle_col ="315",color = colorRampPalette(colors = c("steelblue","white","red"))(10000),border = F)
dev.off()
}
