source("/home/bio-fangc/local/juicer/hic_essential_files/environment.R")

sample_list <- read.table(sample_without_rep_list)[,1]
chr_list <- read.table(chr_list_all)[,1]
resolution_list <- paste(as.character(read.table(resolution_list_tad)[,1]),"k",sep = "")

setwd(arrowhead_tad_folder)

b <- data.frame(NULL)
for (resolution in resolution_list)
{
	#files <- list.files(arrowhead_tad_data_folder,paste("_",resolution,"_domains.sorted.bedpe",sep = ""))
	for (sample in sample_list)
	{
		a <- read.table(paste("./data/",sample,"_KR_",resolution,"_domains.sorted.bedpe",sep = ""))[,1:3]
		a[,4] <- a[,3] - a[,2]
		a[,5] <- sample
		a[,6] <- resolution
		a <- a[,c(5,6,1:4)]
		b <- rbind(b,a)
	}
}
colnames(b) <- c("sample","resolution","chr","TAD_start","TAD_end","TAD_size")
write.table(b,"TAD_size.data",quote = F, col.names = T, row.names = F, sep = "\t")
setwd(arrowhead_tad_size_plot_folder)
library(ggplot2)
for (resolution in resolution_list)
{
	pdf(paste("TAD_size_",resolution,".pdf",sep = ""))
	pic_violin <- ggplot(b[which(b[,2] == resolution),], aes(x=sample, y = TAD_size,color = sample)) +
	geom_violin(trim = T) +
	geom_boxplot(notch = T,width = 0.15)

	pic_density <- ggplot(b[which(b[,2] == resolution),], aes(x=TAD_size)) +
	geom_density(aes(fill = sample),alpha = 0.4)

	print(pic_violin)
	print(pic_density)
	dev.off()
}

