#PBS -S /bin/bash
#PBS -q ser
#PBS -l nodes=1:ppn=1
#PBS -m a
#PBS -j oe
#PBS -N TAD_overlap

source /home/bio-fangc/local/juicer/hic_essential_files/environment.sh

Rscript ${hic_essential_files}/TAD_arrowhead_add_tag.R


if [ ! -d ${hicexplorer_tad_overlap_folder}/ ];then
	mkdir $hicexplorer_tad_overlap_folder
fi

if [ ! -d ${arrowhead_tad_overlap_folder}/ ];then
	mkdir ${arrowhead_tad_overlap_folder}
fi

cat $resolution_list_tad | while read i
do
	cat $overlap_ratio_list_all | while read l
	do
		cat $sample_without_rep_list | while read j
		do
			cat $sample_without_rep_list | while read k
			do
				if [ $j != $k ]
 				then
 					if [ ! -f ${hicexplorer_tad_overlap_folder}/${k}_overlap_with_${j}_${i}k_overlap_ratio_${l}.domains.bed ];then
 						$bedtools intersect -wa -wb -a ${hicexplorer_tad_data_folder}/${j}_KR_${i}k_domains.bed -b ${hicexplorer_tad_data_folder}/${k}_KR_${i}k_domains.bed -f $l -r  > ${hicexplorer_tad_overlap_folder}/${j}_overlap_with_${k}_${i}k_overlap_ratio_${l}.domains.bed
 					fi
 					if [ ! -f ${arrowhead_tad_overlap_folder}/${k}_overlap_with_${j}_${i}k_overlap_ratio_${l}_domains.bedpe ];then	
 						$bedtools intersect -wa -wb -a ${arrowhead_tad_data_folder}/${j}_KR_${i}k_domains.sorted.bedpe -b ${arrowhead_tad_data_folder}/${k}_KR_${i}k_domains.sorted.bedpe -f $l -r  > ${arrowhead_tad_overlap_folder}/${j}_overlap_with_${k}_${i}k_overlap_ratio_${l}_domains.bedpe
 					fi
 				fi
 			done
 		done
 	done
done

# Rscript ${hic_essential_files}/TAD_overlap.R
# Rscript ${hic_essential_files}/TAD_coverage.R
# Rscript ${hic_essential_files}/TAD_size.R