source("/home/bio-fangc/local/juicer/hic_essential_files/environment.R")

sample_list <- read.table(sample_without_rep_list)[,1]
chr_list <- paste("chr",read.table(chr_list_all)[,1],sep = "") 
resolution_list <- paste(as.character(read.table(resolution_list_tad)[,1]),"k",sep = "")
overlap_ratio_list <- sprintf("%0.2f", read.table(overlap_ratio_list_all)[,1])
genome_length <- sum(read.table(genome_size_file)[1:24,][,2])


##=================================3dgenome TAD file==================================================================

setwd(hicexplorer_tad_folder)

b <- data.frame(NULL)
for (resolution in resolution_list)
{
	for (overlap_ratio in overlap_ratio_list)
	{
		files <- list.files(hicexplorer_tad_overlap_folder,paste("_",resolution,"_overlap_ratio_",overlap_ratio,sep = ""))
		for (f in files)
		{
			overlap_file <- paste(hicexplorer_tad_overlap_folder,f,sep = "/")
			overlap_data <- read.table(overlap_file)
			s1 <- strsplit(f,"_overlap_with_")[[1]][1]
			s2 <- strsplit(strsplit(f,"_overlap_with_")[[1]][2],paste("_",resolution,sep = ""))[[1]][1]
			s1_tad_file <- paste(hicexplorer_tad_data_folder,"/",s1,"_KR_",resolution,"_domains.bed",sep = "")
			s2_tad_file <- paste(hicexplorer_tad_data_folder,"/",s2,"_KR_",resolution,"_domains.bed",sep = "")
			s1_tad_data <- read.table(s1_tad_file)
			s2_tad_data <- read.table(s2_tad_file)
			s1_tad_length <- 
			a <- data.frame(s1,s2,resolution,nrow(s1_tad_data),nrow(s2_tad_data),overlap_ratio,nrow(overlap_data),nrow(unique(overlap_data[,1:9])),nrow(unique(overlap_data[,10:18])))
			b <- rbind(b,a)
		}
	}
}

colnames(b) <- c("S1","S2","resolution","S1_TADs","S2_TADs","OR","overlap","S1_overlap_nodup","S2_overlap_nodup")

write.table(b,"TAD_overlap.data",col.names = T, row.names = F, quote = F, sep = "\t")


setwd(hicexplorer_tad_overlap_plot_folder)

library(ggplot2)


for (s1 in sample_list)
{
	for (s2 in sample_list)
	{
		if (s1 != s2)
            {
                c <- b[which(b[,1] == s1 & b[,2] == s2),]
                c[,3] <- factor(as.factor(c[,3]), levels = resolution_list)
                pdf(paste(s1,"_overlap_with_",s2,".pdf",sep = ""))
                pic <- ggplot(c,aes(OR,overlap,fill = resolution)) + 
                geom_col(position = "dodge") +
                scale_y_continuous(expand=c(0,0)) + 
                labs(x="Overlap Ratio", y="Overlapped TADs",title= paste(s1,"overlap with",s2)) + 
                theme(panel.background=element_rect(fill='transparent', color='NA'),panel.grid =element_blank()) + 
                theme(plot.title = element_text(size = 10, hjust = 0.5)) + 
                theme(axis.line = element_line(colour='black')) +
                theme(axis.title.y = element_text(size = 10)) + 
                theme(axis.text.x = element_text(size = 10, hjust = 0, angle = -45))
                print(pic)
                dev.off()
            }
	}
}

##====================================arrowhead TAD file================================================================

setwd(arrowhead_tad_folder)

k <- data.frame(NULL)
for (resolution in resolution_list)
{
	for (overlap_ratio in overlap_ratio_list)
	{
		files <- list.files(arrowhead_tad_overlap_folder,paste("_",resolution,"_overlap_ratio_",overlap_ratio,sep = ""))
		for (f in files)
		{
			overlap_file <- paste(arrowhead_tad_overlap_folder,f,sep = "/")
			overlap_data <- read.table(overlap_file)
			p1 <- strsplit(f,"_overlap_with_")[[1]][1]
			p2 <- strsplit(strsplit(f,"_overlap_with_")[[1]][2],paste("_",resolution,sep = ""))[[1]][1]
			p1_tad_file <- paste(arrowhead_tad_data_folder,"/",p1,"_KR_",resolution,"_domains.sorted.bedpe",sep = "")
			p2_tad_file <- paste(arrowhead_tad_data_folder,"/",p2,"_KR_",resolution,"_domains.sorted.bedpe",sep = "")
			p1_tad_data <- read.table(p1_tad_file)
			p2_tad_data <- read.table(p2_tad_file)
			j <- data.frame(p1,p2,resolution,nrow(p1_tad_data),nrow(p2_tad_data),overlap_ratio,nrow(overlap_data),nrow(unique(overlap_data[,1:16])),nrow(unique(overlap_data[,17:32])))
			k <- rbind(k,j)
		}
	}
}

colnames(k) <- c("p1","p2","resolution","p1_TADs","p2_TADs","OR","overlap","p1_overlap_nodup","p2_overlap_nodup")

write.table(k,"TAD_overlap.data",col.names = T, row.names = F, quote = F, sep = "\t")



setwd(arrowhead_tad_overlap_plot_folder)

library(ggplot2)


for (p1 in sample_list)
{
	for (p2 in sample_list)
	{
		if (p1 != p2)
            {
                l <- k[which(k[,1] == p1 & k[,2] == p2),]
                [,3] <- factor(as.factor([,3]), levels = resolution_list)
                pdf(paste(p1,"_overlap_with_",p2,".pdf",sep = ""))
                pic <- ggplot(l,aes(OR,overlap,fill = resolution)) + 
                geom_col(position = "dodge") +
                scale_y_continuous(expand=c(0,0)) + 
                labs(x="Overlap Ratio", y="Overlapped TADs",title= paste(p1,"overlap with",p2)) + 
                theme(panel.background=element_rect(fill='transparent', color='NA'),panel.grid =element_blank()) + 
                theme(plot.title = element_text(size = 10, hjust = 0.5)) + 
                theme(axis.line = element_line(colour='black')) +
                theme(axis.title.y = element_text(size = 10)) + 
                theme(axis.text.x = element_text(size = 10, hjust = 0, angle = -45))
                print(pic)
                dev.off()
            }
	}
}

##===================================================================================================================
# 
# 
# for (s1 in sample_list)
# {
# 	for (s2 in sample_list)
# 	{
# 		if (s1 != s2)
# 		{
# 			data <- b[which(b[,1] == s1 & b[,2] == s2 & b[,8] == b[,9]),]
# 			o <- names(which(table(data[,6]) == length(resolution_list)))
# 		}
# 	}
# }
# 
# 
# names(which(table(test[,6]) == length(sample_list)*(length(sample_list) -1)*length(resolution_list)))
# 
