source("/home/bio-fangc/local/juicer/hic_essential_files/environment.R")

sample_list <- read.table(sample_without_rep_list)[,1]
chr_list <- read.table(chr_list_all)[,1]
resolution_list <- paste(as.character(read.table(resolution_list_tad)[,1]),"k",sep = "")
overlap_ratio_list <- sprintf("%0.2f", read.table(overlap_ratio_list_all)[,1])
chr_size_list <- read.table(genome_size_file)[1:24,]
setwd(arrowhead_tad_folder)

tad_length <- data.frame(NULL)
tad_length_all <- data.frame(NULL)
for (resolution in resolution_list)
{
	for (sample in sample_list)
	{
		a <- read.table(paste(arrowhead_tad_data_folder,"/",sample,"_KR_",resolution,"_domains.merged.bedpe",sep = ""))
		a[,4] <- a[,3] - a[,2]
		for (chr in chr_list)
		{
			b <- a[which(a[,1] == chr),]
			chr_length <- chr_size_list[which(chr_size_list[,1] == paste("chr",chr,sep = "")),][,2]
			chr_tad_length <- data.frame(sample,resolution,paste("chr",chr,sep = ""),sum(b[,4]),chr_length,sum(b[,4])/chr_length)
			colnames(chr_tad_length) <- c("sample","resolution","chr","TAD_length","Chr_length","TAD_coverage")
			tad_length <- rbind(tad_length,chr_tad_length)
		}
		sample_tad_length <- data.frame(sample, resolution, sum(a[,4]),sum(chr_size_list[,2]),sum(a[,4])/sum(chr_size_list[,2]))
		colnames(sample_tad_length) <- c("sample","resolution","TAD_length","Genome_length","TAD_coverage")
		tad_length_all <- rbind(tad_length_all,sample_tad_length)
	}
}

write.table(tad_length,"TAD_coverage_per_chr.data",quote = F, col.names = T, row.names = F, sep = "\t")
write.table(tad_length,"TAD_coverage_all.data",quote = F, col.names = T, row.names = F, sep = "\t")

setwd(TAD_coverage_plot_folder)
library(ggplot2)
for (resolution in resolution_list)
{
	l <-  tad_length[which(tad_length[,2] == resolution),]
	l[,3] <- factor(as.factor(l[,3]), levels = paste("chr",read.table(chr_list_all)[,1],sep = ""))
	pdf(paste("TAD_coverage_per_chr_",resolution,".pdf",sep = ""))
	pic <- ggplot(l,aes(chr,TAD_coverage,fill = sample)) + 
	geom_col(position = "dodge") +
	scale_y_continuous(expand=c(0,0)) + 
	labs(x="Chromosome", y="TAD coverage ratio",title= paste("TAD_coverage_per_chr_",resolution,sep = "")) + 
	theme(panel.background=element_rect(fill='transparent', color='NA'),panel.grid =element_blank()) + 
	theme(plot.title = element_text(size = 10, hjust = 0.5)) + 
	theme(axis.line = element_line(colour='black')) +
	theme(axis.title.y = element_text(size = 10)) + 
	theme(axis.text.x = element_text(size = 8, hjust = 0, angle = -45))
	print(pic)
	dev.off()
}

tad_length_all[,2] <- factor(as.factor(tad_length_all[,2]), levels = resolution_list)
pdf("TAD_coverage_whole_genome.pdf")
pic <- ggplot(tad_length_all,aes(resolution,TAD_coverage,fill = sample)) + 
geom_col(position = "dodge") +
scale_y_continuous(expand=c(0,0)) + 
labs(x="Resolution", y="TAD coverage ratio",title= "TAD_coverage_whole_genome") + 
theme(panel.background=element_rect(fill='transparent', color='NA'),panel.grid =element_blank()) + 
theme(plot.title = element_text(size = 10, hjust = 0.5)) + 
theme(axis.line = element_line(colour='black')) +
theme(axis.title.y = element_text(size = 10)) + 
theme(axis.text.x = element_text(size = 8, hjust = 0, angle = 0))
print(pic)
dev.off()

