#PBS -S /bin/bash
#PBS -q ser
#PBS -l nodes=1:ppn=1
#PBS -m a
#PBS -j oe
#PBS -N Eigenvector

 source /home/bio-fangc/local/juicer/hic_essential_files/environment.sh

cat $resolution_list_eigenvector | while read k
do
	mkdir ${eigenvector_folder}/${k}k ${eigenvector_corrected_folder}/${k}k
	cat $sample_without_rep_list | while read i
	do 
		cat $chr_list_all | while read j
		do
			$juicer_tools eigenvector -p KR ${hic_folder}/${i}.hic $j BP ${k}000  | awk '(NR>2){print $0}' >  ${eigenvector_folder}/${k}k/${i}_chr${j}_eigenvector_KR_${k}k
			sed -i 's/NaN/0/g' ${eigenvector_folder}/${k}k/${i}_chr${j}_eigenvector_KR_${k}k
			cp ${eigenvector_folder}/${k}k/${i}_chr${j}_eigenvector_KR_${k}k ${eigenvector_corrected_folder}/${k}k/${i}_chr${j}_eigenvector_KR_${k}k
			paste ${genedensity_folder}/${k}k/genedensity_${k}k_chr${j}.bed ${eigenvector_corrected_folder}/${k}k/${i}_chr${j}_eigenvector_KR_${k}k > ${eigenvector_corrected_folder}/${k}k/${i}_chr${j}_eigenvector_KR_${k}k_with_genesdensity
			cat ${eigenvector_corrected_folder}/${k}k/${i}_chr${j}_eigenvector_KR_${k}k_with_genesdensity | awk -vI=$i -vJ=$j -vK=$k 'BEGIN{sumPos=0;sumNeg=0;pos=0;neg=0}{if($6>0&&$6!="NaN"){pos++;sumPos+=$5}else if($6<0&&$6!="NaN"){neg++;sumNeg+=$5}}END{print I"_chr"J"_eigenvector_KR_"K"k","pos",sumPos,pos,sumPos/pos,"neg",sumNeg,neg,sumNeg/neg,"pos-neg",sumPos/pos-sumNeg/neg}' >> ${eigenvector_corrected_folder}/${k}k/average_gene_density_${k}k.txt
		done
	done
done

Rscript ${hic_essential_files}/eigenvector_correction.R

cat $resolution_list_eigenvector | while read k
do
	/bin/rm -rf ${eigenvector_corrected_folder}/${k}k/*_with_genesdensity
done

Rscript ${hic_essential_files}/eigenvector_plot.R
