source $1

n_sh=1
for library in ${libraries[*]}
do
	library_dir=${work_dir}/${library}
	fastq_dir=${library_dir}/fastq

	ls ${fastq_dir}/${library}*_read1.fastq | while read i
	do
		full_name=$(basename $i _read1.fastq)
		script_name=${full_name}_alignment
		script_sh=${script_name}.sh

		if [ $cluster == "qiming" ];then
			home_dir=/home/bio-fangc
			echo -e "#PBS -S /bin/bash
					 #PBS -V
					 #PBS -q ser
					 #PBS -l nodes=1:ppn=align_core
					 #PBS -m a
					 #PBS -j oe
					 #PBS -N Job_name" > $script_sh
		elif [ $cluster == "taiyi" ];then
			home_dir=/work/bio-fangc
			echo -e '#!/bin/sh
					#BSUB -J Job_name
					#BSUB -q ser
					#BSUB -n align_core
					#BSUB -R "span[ptile=40]"' > $script_sh
		fi

		sed -i 's/^[[:space:]]*//g' $script_sh
		sed -i "s/Job_name/$script_name/g" $script_sh
		sed -i "s/align_core/$align_core/g" $script_sh

		read1_file=$i
		read2_file=$(echo $i | sed 's/_read1/_read2/g')

		sample_name=${full_name%"_slice"*}
		split_dir=${library_dir}/splits
		split_prefix=${split_dir}/$(basename $i _read1.fastq).fastq
		thread_str=$(echo $align_core*2 | bc)

		if [ ! -d $split_dir ];then	mkdir $split_dir;fi

		echo -e \
		"\n\
		\nif [ ! -e ${split_prefix}_norm.txt.res.txt ];then\
			\n\tnum1=\$(\\\
				\n\t\tpaste \\\
				\n\t\t\t$read1_file \\\
				\n\t\t\t$read2_file | \\\
				\n\t\t$awk_cmd '!((NR+2)%4)' | \\\
				\n\t\tgrep -cE $ligation\\\
			\n\t) \
			\n\
			\n\techo \\\
				\n\t\t-ne \\\
				\n\t\t\"\$num1 \" \\\
			\n\t> ${split_prefix}_norm.txt.res.txt\
			\n\
		\nfi\
		\nif [ ! -e ${split_prefix}_linecount.txt ];then\
			\n\tnum2=\$(\\\
				\n\t\twc \\\
					\n\t\t\t-l \\\
					\n\t\t\t$read1_file | \\\
				\n\t\t$awk_cmd '{print \$1}'\\\
			\n\t) \
			\n\
			\n\techo \\\
				\n\t\t\"\$num2\" \\\
			\n\t> ${split_prefix}_linecount.txt\
			\n\
		\nfi\
		\nif [ ! -e ${split_prefix}.sam ];then\
			\n\t$bwa_cmd \\\
				\n\t\tmem \\\
					\n\t\t\t-SP5M \\\
					\n\t\t\t-t $thread_str \\\
					\n\t\t\t$bwa_index \\\
					\n\t\t\t$read1_file \\\
					\n\t\t\t$read2_file \\\
			\n\t> ${split_prefix}.sam\
		\nfi\
		\n\
		\nif [ ! -e ${split_prefix}.bam ];then\
			\n\t$awk_cmd \\\
				\n\t\t-v stem=${split_prefix}_norm \\\
				\n\t\t-v site_file=$site_file \\\
				\n\t\t-f ${common_dir}/chimeric_sam.awk \\\
				\n\t\t${split_prefix}.sam | \\\
			\n\t$samtools_cmd \\\
				\n\t\tsort \\\
					\n\t\t\t-t cb \\\
					\n\t\t\t-n \\\
					\n\t\t\t-@ $thread_str \\\
			\n\t> ${split_prefix}.bam \
		\nfi
		\n" >> $script_sh

		sed -i 's/[[:space:]]*$//g' $script_sh
		if [ $2 -eq 1 ];then
			if [ $cluster == "qiming" ];then
				qsub $script_sh
			elif [ $cluster == "taiyi" ];then
				bsub < $script_sh
			fi
			/bin/rm -rf $script_sh
			echo "You've submitted $n_sh jobs"
			n_sh=$(echo $n_sh +1 | bc)
		fi
	done
done
