/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import java.io.File;
import java.util.List;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;
import picard.vcf.filter.AlleleBalanceFilter;
import picard.vcf.filter.DepthFilter;
import picard.vcf.filter.FilterApplyingVariantIterator;
import picard.vcf.filter.FisherStrandFilter;
import picard.vcf.filter.GenotypeFilter;
import picard.vcf.filter.GenotypeQualityFilter;
import picard.vcf.filter.QdFilter;
import picard.vcf.filter.VariantFilter;

@CommandLineProgramProperties(usage="Applies one or more hard filters to a VCF file to filter out genotypes and variants.", usageShort="Hard filters a VCF.", programGroup=VcfOrBcf.class)
public class FilterVcf
extends CommandLineProgram {
    @Option(shortName="I", doc="The INPUT VCF or BCF file.")
    public File INPUT;
    @Option(shortName="O", doc="The output VCF or BCF.")
    public File OUTPUT;
    @Option(doc="The minimum allele balance acceptable before filtering a site. Allele balance is calculated for heterozygotes as the number of bases supporting the least-represented allele over the total number of base observations. Different heterozygote genotypes at the same locus are measured independently. The locus is filtered if any allele balance is below the limit.")
    public double MIN_AB = 0.0;
    @Option(doc="The minimum sequencing depth supporting a genotype before the genotype will be filtered out.")
    public int MIN_DP = 0;
    @Option(doc="The minimum genotype quality that must be achieved for a sample otherwise the genotype will be filtered out.")
    public int MIN_GQ = 0;
    @Option(doc="The maximum phred scaled fisher strand value before a site will be filtered out.")
    public double MAX_FS = Double.MAX_VALUE;
    @Option(doc="The minimum QD value to accept or otherwise filter out the variant.")
    public double MIN_QD = 0.0;

    public FilterVcf() {
        this.CREATE_INDEX = true;
    }

    public static void main(String[] args) {
        new FilterVcf().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        List<VariantFilter> variantFilters = CollectionUtil.makeList(new AlleleBalanceFilter(this.MIN_AB), new FisherStrandFilter(this.MAX_FS), new QdFilter(this.MIN_QD));
        List<GenotypeFilter> genotypeFilters = CollectionUtil.makeList(new GenotypeQualityFilter(this.MIN_GQ), new DepthFilter(this.MIN_DP));
        VCFFileReader in = new VCFFileReader(this.INPUT, false);
        FilterApplyingVariantIterator iterator2 = new FilterApplyingVariantIterator(in.iterator(), variantFilters, genotypeFilters);
        VariantContextWriter out = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).build();
        VCFHeader header = in.getFileHeader();
        header.addMetaDataLine(new VCFFilterHeaderLine("AllGtsFiltered", "Site filtered out because all genotypes are filtered out."));
        header.addMetaDataLine(new VCFFormatHeaderLine("FT", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Genotype filters."));
        for (VariantFilter filter : variantFilters) {
            for (VCFFilterHeaderLine line : filter.headerLines()) {
                header.addMetaDataLine(line);
            }
        }
        out.writeHeader(in.getFileHeader());
        while (iterator2.hasNext()) {
            out.add(iterator2.next());
        }
        out.close();
        in.close();
        return 0;
    }
}

