/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Reads a VCF/VCF.gz/BCF and removes all genotype information from it while retaining all site level information, including annotations based on genotypes (e.g. AN, AF). Output an be any support variant format including .vcf, .vcf.gz or .bcf.", usageShort="Creates a VCF bereft of genotype information from an input VCF or BCF", programGroup=VcfOrBcf.class)
public class MakeSitesOnlyVcf
extends CommandLineProgram {
    @Option(shortName="I", doc="Input VCF or BCF")
    public File INPUT;
    @Option(shortName="O", doc="Output VCF or BCF to emit without per-sample info.")
    public File OUTPUT;
    @Option(shortName="S", doc="Optionally one or more samples to retain when building the 'sites-only' VCF.", optional=true)
    public Set<String> SAMPLE = new TreeSet<String>();

    public static void main(String[] args) {
        new MakeSitesOnlyVcf().instanceMainWithExit(args);
    }

    public MakeSitesOnlyVcf() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        VCFFileReader reader = new VCFFileReader(this.INPUT, false);
        VCFHeader inputVcfHeader = new VCFHeader(reader.getFileHeader().getMetaDataInInputOrder());
        SAMSequenceDictionary sequenceDictionary = inputVcfHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        ProgressLogger progress = new ProgressLogger(Log.getInstance(MakeSitesOnlyVcf.class), 10000);
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).setReferenceDictionary(sequenceDictionary);
        if (this.CREATE_INDEX.booleanValue()) {
            builder.setOption(Options.INDEX_ON_THE_FLY);
        } else {
            builder.unsetOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter writer = builder.build();
        VCFHeader header = new VCFHeader(inputVcfHeader.getMetaDataInInputOrder(), this.SAMPLE);
        writer.writeHeader(header);
        Iterator iterator2 = reader.iterator();
        while (iterator2.hasNext()) {
            VariantContext full = (VariantContext)iterator2.next();
            VariantContext site = MakeSitesOnlyVcf.subsetToSamplesWithOriginalAnnotations(full, this.SAMPLE);
            writer.add(site);
            progress.record(site.getChr(), site.getStart());
        }
        CloserUtil.close(iterator2);
        CloserUtil.close(reader);
        writer.close();
        return 0;
    }

    private static VariantContext subsetToSamplesWithOriginalAnnotations(VariantContext ctx, Set<String> samples) {
        VariantContextBuilder builder = new VariantContextBuilder(ctx);
        GenotypesContext newGenotypes = ctx.getGenotypes().subsetToSamples(samples);
        builder.alleles((Collection<Allele>)ctx.getAlleles());
        return builder.genotypes(newGenotypes).make();
    }
}

