/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IntervalListScatterer {
    private final Mode mode;

    public IntervalListScatterer(Mode mode) {
        this.mode = mode;
    }

    private int deduceIdealSplitLength(IntervalList uniquedList, int scatterCount) {
        int splitWidth = Math.max((int)Math.floor((double)uniquedList.getBaseCount() / (1.0 * (double)scatterCount)), 1);
        switch (this.mode) {
            case INTERVAL_SUBDIVISION: {
                return splitWidth;
            }
            case BALANCING_WITHOUT_INTERVAL_SUBDIVISION: {
                int widestIntervalLength = Collections.max(uniquedList.getIntervals(), new Comparator<Interval>(){

                    @Override
                    public int compare(Interval o1, Interval o2) {
                        return Integer.valueOf(o1.length()).compareTo(o2.length());
                    }
                }).length();
                return Math.max(widestIntervalLength, splitWidth);
            }
        }
        throw new IllegalStateException();
    }

    public List<IntervalList> scatter(IntervalList sourceIntervalList, int scatterCount) {
        if (scatterCount < 1) {
            throw new IllegalArgumentException("scatterCount < 1");
        }
        IntervalList uniquedList = sourceIntervalList.uniqued();
        long idealSplitLength = this.deduceIdealSplitLength(uniquedList, scatterCount);
        ArrayList<IntervalList> accumulatedIntervalLists = new ArrayList<IntervalList>();
        IntervalList runningIntervalList = new IntervalList(uniquedList.getHeader());
        ArrayDeque<Interval> intervalQueue = new ArrayDeque<Interval>(uniquedList.getIntervals());
        while (!intervalQueue.isEmpty() && accumulatedIntervalLists.size() < scatterCount - 1) {
            Interval interval = intervalQueue.pollFirst();
            long projectedSize = runningIntervalList.getBaseCount() + (long)interval.length();
            if (projectedSize <= idealSplitLength) {
                runningIntervalList.add(interval);
            } else {
                switch (this.mode) {
                    case INTERVAL_SUBDIVISION: {
                        int amountToConsume = (int)(idealSplitLength - runningIntervalList.getBaseCount());
                        Interval left = new Interval(interval.getSequence(), interval.getStart(), interval.getStart() + amountToConsume - 1, interval.isNegativeStrand(), interval.getName());
                        Interval right = new Interval(interval.getSequence(), interval.getStart() + amountToConsume, interval.getEnd(), interval.isNegativeStrand(), interval.getName());
                        runningIntervalList.add(left);
                        intervalQueue.addFirst(right);
                        break;
                    }
                    case BALANCING_WITHOUT_INTERVAL_SUBDIVISION: {
                        if (runningIntervalList.getIntervals().isEmpty()) {
                            runningIntervalList.add(interval);
                            break;
                        }
                        intervalQueue.addFirst(interval);
                        accumulatedIntervalLists.add(runningIntervalList);
                        runningIntervalList = new IntervalList(uniquedList.getHeader());
                    }
                }
            }
            if (runningIntervalList.getBaseCount() < idealSplitLength) continue;
            accumulatedIntervalLists.add(runningIntervalList);
            runningIntervalList = new IntervalList(uniquedList.getHeader());
        }
        while (!intervalQueue.isEmpty()) {
            runningIntervalList.add(intervalQueue.pollFirst());
        }
        if (!runningIntervalList.getIntervals().isEmpty()) {
            accumulatedIntervalLists.add(runningIntervalList);
        }
        return accumulatedIntervalLists;
    }

    public static enum Mode {
        INTERVAL_SUBDIVISION,
        BALANCING_WITHOUT_INTERVAL_SUBDIVISION;

    }
}

