/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import picard.PicardException;

public class CircularByteBuffer {
    private final byte[] bytes;
    private final int capacity;
    private int nextWritePos = 0;
    private int bytesAvailableToWrite;
    private int nextReadPos = 0;
    private int bytesAvailableToRead = 0;
    private boolean closed = false;

    public CircularByteBuffer(int size) {
        this.bytes = new byte[size];
        this.bytesAvailableToWrite = this.capacity = this.bytes.length;
    }

    public synchronized int write(byte[] bytes2, int start, int size) {
        if (this.closed) {
            throw new IllegalStateException("Cannot write to closed buffer.");
        }
        try {
            if (this.bytesAvailableToWrite == 0) {
                this.wait();
            }
        }
        catch (InterruptedException ie) {
            throw new PicardException("Interrupted while waiting to write to fifo.", ie);
        }
        int writePos = this.nextWritePos;
        int distanceToEnd = this.capacity - writePos;
        int available = distanceToEnd < this.bytesAvailableToWrite ? distanceToEnd : this.bytesAvailableToWrite;
        int length = available < size ? available : size;
        System.arraycopy(bytes2, start, this.bytes, writePos, length);
        this.bytesAvailableToWrite -= length;
        this.bytesAvailableToRead += length;
        this.nextWritePos = (writePos + length) % this.capacity;
        this.notify();
        return length;
    }

    public synchronized int read(byte[] bytes2, int start, int size) {
        try {
            if (this.bytesAvailableToRead == 0 && !this.closed) {
                this.wait();
            }
        }
        catch (InterruptedException ie) {
            throw new PicardException("Interrupted while waiting to read from fifo.", ie);
        }
        int readPos = this.nextReadPos;
        int distanceToEnd = this.capacity - readPos;
        int available = distanceToEnd < this.bytesAvailableToRead ? distanceToEnd : this.bytesAvailableToRead;
        int length = available < size ? available : size;
        System.arraycopy(this.bytes, readPos, bytes2, start, length);
        this.bytesAvailableToRead -= length;
        this.bytesAvailableToWrite += length;
        this.nextReadPos = (readPos + length) % this.capacity;
        this.notify();
        return length;
    }

    public synchronized void close() {
        this.closed = true;
        this.notify();
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized int getBytesAvailableToRead() {
        return this.bytesAvailableToRead;
    }
}

