/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.PerTileParser;
import picard.illumina.parser.PfData;
import picard.illumina.parser.readers.FilterFileReader;

class FilterParser
extends PerTileParser<PfData> {
    private static Set<IlluminaDataType> supportedTypes = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.PF));

    public FilterParser(IlluminaFileMap tilesToFiles) {
        super(tilesToFiles);
    }

    public FilterParser(IlluminaFileMap tilesToFiles, int startingTile) {
        super(tilesToFiles, startingTile);
    }

    @Override
    protected CloseableIterator<PfData> makeTileIterator(final File iterator2) {
        return new CloseableIterator<PfData>(){
            private FilterFileReader reader;
            {
                this.reader = new FilterFileReader(iterator2);
            }

            @Override
            public void close() {
                this.reader = null;
            }

            @Override
            public boolean hasNext() {
                return this.reader.hasNext();
            }

            @Override
            public PfData next() {
                final boolean nextValue = this.reader.next();
                return new PfData(){

                    @Override
                    public boolean isPf() {
                        return nextValue;
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return supportedTypes;
    }
}

