/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.List;
import java.util.Set;
import picard.analysis.AlignmentSummaryMetricsCollector;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.IlluminaUtil;

@CommandLineProgramProperties(usage="Produces from a SAM or BAM a file containing summary alignment metrics", usageShort="Produces from a SAM or BAM a file containing summary alignment metrics", programGroup=Metrics.class)
public class CollectAlignmentSummaryMetrics
extends SinglePassSamProgram {
    static final String USAGE = "Produces from a SAM or BAM a file containing summary alignment metrics";
    private static final Log log = Log.getInstance(CollectAlignmentSummaryMetrics.class);
    @Option(doc="Paired end reads above this insert size will be considered chimeric along with inter-chromosomal pairs.")
    public int MAX_INSERT_SIZE = 100000;
    @Option(doc="List of adapter sequences to use when processing the alignment metrics")
    public List<String> ADAPTER_SEQUENCE = CollectionUtil.makeList(IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get3PrimeAdapter());
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    private Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    @Option(shortName="BS", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads.  ")
    public boolean IS_BISULFITE_SEQUENCED = false;
    private AlignmentSummaryMetricsCollector collector;

    public static void main(String[] argv) {
        new CollectAlignmentSummaryMetrics().instanceMainWithExit(argv);
    }

    protected final int testDoWork() {
        return this.doWork();
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable(this.OUTPUT);
        if (header.getSequenceDictionary().isEmpty()) {
            log.warn(this.INPUT.getAbsoluteFile() + " has no sequence dictionary.  If any reads " + "in the file are aligned then alignment summary metrics collection will fail.");
        }
        boolean doRefMetrics = this.REFERENCE_SEQUENCE != null;
        this.collector = new AlignmentSummaryMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, header.getReadGroups(), doRefMetrics, this.ADAPTER_SEQUENCE, this.MAX_INSERT_SIZE, this.IS_BISULFITE_SEQUENCED);
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        this.collector.acceptRecord(rec, ref);
    }

    @Override
    protected void finish() {
        this.collector.finish();
        MetricsFile file = this.getMetricsFile();
        this.collector.addAllLevelsToFile(file);
        file.write(this.OUTPUT);
    }
}

