/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.npy;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.npy.NpyArray;
import org.jetbrains.bio.npy.NpyFile;
import org.jetbrains.bio.npy.NpzEntry;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/bio/npy/NpzFile;", "", "()V", "read", "Lorg/jetbrains/bio/npy/NpzFile$Reader;", "path", "Ljava/nio/file/Path;", "write", "Lorg/jetbrains/bio/npy/NpzFile$Writer;", "compressed", "", "Reader", "Writer", "npy_main"})
public final class NpzFile {
    public static final NpzFile INSTANCE;

    @JvmStatic
    @NotNull
    public static final Reader read(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return new Reader(path);
    }

    @JvmStatic
    @NotNull
    public static final Writer write(@NotNull Path path, boolean compressed) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return new Writer(path, compressed);
    }

    @JvmStatic
    @NotNull
    public static /* bridge */ /* synthetic */ Writer write$default(Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return NpzFile.write(path, bl);
    }

    private NpzFile() {
        INSTANCE = this;
    }

    static {
        new NpzFile();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\t\u0010\n\u001a\u00020\u0004H\u00c2\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\u001b\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0086\u0002J\t\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\t\u0010\u001a\u001a\u00020\u0013H\u00d6\u0001J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/bio/npy/NpzFile$Reader;", "Ljava/io/Closeable;", "Ljava/lang/AutoCloseable;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "zf", "Ljava/util/zip/ZipFile;", "close", "", "component1", "copy", "equals", "", "other", "", "get", "Lorg/jetbrains/bio/npy/NpyArray;", "name", "", "step", "", "hashCode", "introspect", "", "Lorg/jetbrains/bio/npy/NpzEntry;", "toString", "getBuffers", "Lkotlin/sequences/Sequence;", "Ljava/nio/ByteBuffer;", "entry", "Ljava/util/zip/ZipEntry;", "npy_main"})
    public static final class Reader
    implements Closeable,
    AutoCloseable {
        private final ZipFile zf;
        private final Path path;

        @NotNull
        public final List<NpzEntry> introspect() {
            Enumeration<? extends ZipEntry> enumeration = this.zf.entries();
            return SequencesKt.toList(SequencesKt.map(SequencesKt.asSequence(CollectionsKt.iterator(enumeration)), (Function1)new Function1<ZipEntry, NpzEntry>(this){
                final /* synthetic */ Reader this$0;

                @NotNull
                public final NpzEntry invoke(ZipEntry it) {
                    Class<Object> clazz;
                    ZipFile zipFile = Reader.access$getZf$p(this.this$0);
                    ZipEntry zipEntry = it;
                    Intrinsics.checkExpressionValueIsNotNull(zipEntry, "it");
                    NpyFile.Header header = NpyFile.Header.Companion.read((ByteBuffer)SequencesKt.first(Reader.access$getBuffers(this.this$0, zipFile, zipEntry, Integer.MAX_VALUE)));
                    block0 : switch (header.getType()) {
                        case 'b': {
                            clazz = Boolean.TYPE;
                            break;
                        }
                        case 'i': 
                        case 'u': {
                            switch (header.getBytes()) {
                                case 1: {
                                    clazz = Byte.TYPE;
                                    break block0;
                                }
                                case 2: {
                                    clazz = Short.TYPE;
                                    break block0;
                                }
                                case 4: {
                                    clazz = Integer.TYPE;
                                    break block0;
                                }
                                case 8: {
                                    clazz = Long.TYPE;
                                    break block0;
                                }
                            }
                            throw (Throwable)new IllegalStateException("Unexpected header: " + header.getBytes());
                        }
                        case 'f': {
                            switch (header.getBytes()) {
                                case 4: {
                                    clazz = Float.TYPE;
                                    break block0;
                                }
                                case 8: {
                                    clazz = Double.TYPE;
                                    break block0;
                                }
                            }
                            throw (Throwable)new IllegalStateException("Unexpected header: " + header.getBytes());
                        }
                        case 'S': {
                            clazz = String.class;
                            break;
                        }
                        default: {
                            throw (Throwable)new IllegalStateException("Unexpected header: " + header.getType());
                        }
                    }
                    Class<Object> type = clazz;
                    return new NpzEntry(StringsKt.substringBeforeLast$default(it.getName(), '.', null, 2, null), type, header.getShape());
                }
                {
                    this.this$0 = reader;
                    super(1);
                }
            }));
        }

        @NotNull
        public final NpyArray get(@NotNull String name, int step) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            ZipEntry zipEntry = this.zf.getEntry(name + ".npy");
            Intrinsics.checkExpressionValueIsNotNull(zipEntry, "zf.getEntry(name + \".npy\")");
            return NpyFile.INSTANCE.read$npy_main(this.getBuffers(this.zf, zipEntry, step));
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NpyArray get$default(Reader reader, String string, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 262144;
            }
            return reader.get(string, n);
        }

        /*
         * WARNING - void declaration
         */
        private final Sequence<ByteBuffer> getBuffers(@NotNull ZipFile $receiver, ZipEntry entry, int step) {
            void chunk;
            InputStream is = $receiver.getInputStream(entry);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = ByteBuffer.allocate(0);
            return SequencesKt.generateSequence((Function0)new Function0<ByteBuffer>(is, (Ref.ObjectRef)chunk, step){
                final /* synthetic */ InputStream $is;
                final /* synthetic */ Ref.ObjectRef $chunk;
                final /* synthetic */ int $step;

                @Nullable
                public final ByteBuffer invoke() {
                    ByteBuffer byteBuffer;
                    int remaining = this.$is.available() + ((ByteBuffer)this.$chunk.element).remaining();
                    if (remaining > 0) {
                        ByteBuffer byteBuffer2 = ByteBuffer.allocate(Math.min(remaining, this.$step));
                        Ref.ObjectRef objectRef = this.$chunk;
                        ByteBuffer $receiver = byteBuffer2;
                        $receiver.put((ByteBuffer)this.$chunk.element);
                        Channels.newChannel(this.$is).read($receiver);
                        $receiver.rewind();
                        ByteBuffer byteBuffer3 = byteBuffer2;
                        objectRef.element = byteBuffer3.asReadOnlyBuffer();
                        byteBuffer = (ByteBuffer)this.$chunk.element;
                    } else {
                        this.$is.close();
                        byteBuffer = null;
                    }
                    return byteBuffer;
                }
                {
                    this.$is = inputStream;
                    this.$chunk = objectRef;
                    this.$step = n;
                    super(0);
                }
            });
        }

        @Override
        public void close() {
            this.zf.close();
        }

        public Reader(@NotNull Path path) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            this.path = path;
            this.zf = new ZipFile(this.path.toFile(), 1, Charsets.US_ASCII);
        }

        @NotNull
        public static final /* synthetic */ Sequence access$getBuffers(Reader $this, @NotNull ZipFile $receiver, @NotNull ZipEntry entry, int step) {
            return $this.getBuffers($receiver, entry, step);
        }

        @NotNull
        public static final /* synthetic */ ZipFile access$getZf$p(Reader $this) {
            return $this.zf;
        }

        private final Path component1() {
            return this.path;
        }

        @NotNull
        public final Reader copy(@NotNull Path path) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            return new Reader(path);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Reader copy$default(Reader reader, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                path = reader.path;
            }
            return reader.copy(path);
        }

        public String toString() {
            return "Reader(path=" + this.path + ")";
        }

        public int hashCode() {
            Path path = this.path;
            return path != null ? ((Object)path).hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Reader)) break block3;
                    Reader reader = (Reader)object;
                    if (!Intrinsics.areEqual(this.path, reader.path)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0018\n\u0002\u0010\u0012\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0016\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c2\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J-\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cJ\"\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u001d2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007J\"\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u001e2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u001f2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010 \u001a\u00020!H\u0002J,\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\"2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010 \u001a\u00020!H\u0002J,\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u001b2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010 \u001a\u00020!H\u0007J,\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020#2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010 \u001a\u00020!H\u0002J,\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020$2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010 \u001a\u00020!H\u0002J\u001e\u0010%\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/bio/npy/NpzFile$Writer;", "Ljava/io/Closeable;", "Ljava/lang/AutoCloseable;", "path", "Ljava/nio/file/Path;", "compressed", "", "(Ljava/nio/file/Path;Z)V", "zos", "Ljava/util/zip/ZipOutputStream;", "close", "", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "write", "name", "data", "", "shape", "", "(Ljava/lang/String;[Ljava/lang/String;[I)V", "", "", "", "order", "Ljava/nio/ByteOrder;", "", "", "", "writeEntry", "chunks", "Lkotlin/sequences/Sequence;", "Ljava/nio/ByteBuffer;", "npy_main"})
    public static final class Writer
    implements Closeable,
    AutoCloseable {
        private final ZipOutputStream zos;
        private final Path path;
        private final boolean compressed;

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull boolean[] data, @NotNull int[] shape) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(data, "data");
            Intrinsics.checkParameterIsNotNull(shape, "shape");
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_main(data, shape));
        }

        @JvmOverloads
        public static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, boolean[] blArray, int[] nArray, int n, Object object) {
            if ((n & 4) != 0) {
                nArray = new int[]{blArray.length};
            }
            writer.write(string, blArray, nArray);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull boolean[] data) {
            Writer.write$default(this, name, data, null, 4, null);
        }

        private final void write(String name, byte[] data, int[] shape) {
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_main(data, shape));
        }

        static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, byte[] byArray, int[] nArray, int n, Object object) {
            if ((n & 4) != 0) {
                nArray = new int[]{byArray.length};
            }
            writer.write(string, byArray, nArray);
        }

        private final void write(String name, short[] data, int[] shape, ByteOrder order) {
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_main(data, shape, order));
        }

        static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, short[] sArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
            if ((n & 4) != 0) {
                nArray = new int[]{sArray.length};
            }
            if ((n & 8) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkExpressionValueIsNotNull(byteOrder2, "ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            writer.write(string, sArray, nArray, byteOrder);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull int[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(data, "data");
            Intrinsics.checkParameterIsNotNull(shape, "shape");
            Intrinsics.checkParameterIsNotNull(order, "order");
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_main(data, shape, order));
        }

        @JvmOverloads
        public static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, int[] nArray, int[] nArray2, ByteOrder byteOrder, int n, Object object) {
            if ((n & 4) != 0) {
                nArray2 = new int[]{nArray.length};
            }
            if ((n & 8) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkExpressionValueIsNotNull(byteOrder2, "ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            writer.write(string, nArray, nArray2, byteOrder);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull int[] data, @NotNull int[] shape) {
            Writer.write$default(this, name, data, shape, null, 8, null);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull int[] data) {
            Writer.write$default(this, name, data, null, null, 12, null);
        }

        private final void write(String name, long[] data, int[] shape, ByteOrder order) {
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_main(data, shape, order));
        }

        static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, long[] lArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
            if ((n & 4) != 0) {
                nArray = new int[]{lArray.length};
            }
            if ((n & 8) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkExpressionValueIsNotNull(byteOrder2, "ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            writer.write(string, lArray, nArray, byteOrder);
        }

        private final void write(String name, float[] data, int[] shape, ByteOrder order) {
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_main(data, shape, order));
        }

        static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, float[] fArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
            if ((n & 4) != 0) {
                nArray = new int[]{fArray.length};
            }
            if ((n & 8) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkExpressionValueIsNotNull(byteOrder2, "ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            writer.write(string, fArray, nArray, byteOrder);
        }

        private final void write(String name, double[] data, int[] shape, ByteOrder order) {
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_main(data, shape, order));
        }

        static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, double[] dArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
            if ((n & 4) != 0) {
                nArray = new int[]{dArray.length};
            }
            if ((n & 8) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkExpressionValueIsNotNull(byteOrder2, "ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            writer.write(string, dArray, nArray, byteOrder);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull String[] data, @NotNull int[] shape) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(data, "data");
            Intrinsics.checkParameterIsNotNull(shape, "shape");
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_main(data, shape));
        }

        @JvmOverloads
        public static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, String[] stringArray, int[] nArray, int n, Object object) {
            if ((n & 4) != 0) {
                nArray = new int[]{((Object[])stringArray).length};
            }
            writer.write(string, stringArray, nArray);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull String[] data) {
            Writer.write$default(this, name, data, null, 4, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writeEntry(String name, Sequence<? extends ByteBuffer> chunks) {
            ZipEntry zipEntry;
            ZipEntry $receiver = zipEntry = new ZipEntry(name + ".npy");
            if (this.compressed) {
                $receiver.setMethod(8);
            } else {
                $receiver.setMethod(0);
                CRC32 crcAcc = new CRC32();
                long sizeAcc = 0L;
                Iterator<? extends ByteBuffer> iterator2 = chunks.iterator();
                while (iterator2.hasNext()) {
                    ByteBuffer chunk = iterator2.next();
                    sizeAcc += (long)chunk.capacity();
                    crcAcc.update(chunk);
                    chunk.rewind();
                }
                $receiver.setSize(sizeAcc);
                $receiver.setCrc(crcAcc.getValue());
            }
            ZipEntry entry = zipEntry;
            this.zos.putNextEntry(entry);
            try {
                WritableByteChannel fc = Channels.newChannel(this.zos);
                Iterator<? extends ByteBuffer> iterator3 = chunks.iterator();
                while (iterator3.hasNext()) {
                    ByteBuffer chunk = iterator3.next();
                    while (chunk.hasRemaining()) {
                        fc.write(chunk);
                    }
                }
            }
            finally {
                this.zos.closeEntry();
            }
        }

        @Override
        public void close() {
            this.zos.close();
        }

        public Writer(@NotNull Path path, boolean compressed) {
            ZipOutputStream zipOutputStream;
            Intrinsics.checkParameterIsNotNull(path, "path");
            this.path = path;
            this.compressed = compressed;
            OutputStream outputStream = Files.newOutputStream(this.path, new OpenOption[0]);
            int n = 0;
            boolean bl = true;
            Object var6_6 = null;
            ZipOutputStream zipOutputStream2 = zipOutputStream;
            ZipOutputStream zipOutputStream3 = zipOutputStream;
            Writer writer = this;
            if (bl & true) {
                n = 8192;
            }
            BufferedOutputStream bufferedOutputStream = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n);
            zipOutputStream2((OutputStream)bufferedOutputStream, Charsets.US_ASCII);
            writer.zos = zipOutputStream3;
        }

        private final Path component1() {
            return this.path;
        }

        private final boolean component2() {
            return this.compressed;
        }

        @NotNull
        public final Writer copy(@NotNull Path path, boolean compressed) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            return new Writer(path, compressed);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Writer copy$default(Writer writer, Path path, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                path = writer.path;
            }
            if ((n & 2) != 0) {
                bl = writer.compressed;
            }
            return writer.copy(path, bl);
        }

        public String toString() {
            return "Writer(path=" + this.path + ", compressed=" + this.compressed + ")";
        }

        public int hashCode() {
            Path path = this.path;
            int n = (path != null ? ((Object)path).hashCode() : 0) * 31;
            int n2 = this.compressed ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Writer)) break block3;
                    Writer writer = (Writer)object;
                    if (!Intrinsics.areEqual(this.path, writer.path) || !(this.compressed == writer.compressed)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

