/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.npy;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.npy.ArrayMerger;
import org.jetbrains.bio.npy.BooleanArrayChunker;
import org.jetbrains.bio.npy.BooleanArrayMerger;
import org.jetbrains.bio.npy.ByteArrayMerger;
import org.jetbrains.bio.npy.DictParserKt;
import org.jetbrains.bio.npy.DoubleArrayChunker;
import org.jetbrains.bio.npy.DoubleArrayMerger;
import org.jetbrains.bio.npy.FloatArrayChunker;
import org.jetbrains.bio.npy.FloatArrayMerger;
import org.jetbrains.bio.npy.IntArrayChunker;
import org.jetbrains.bio.npy.IntArrayMerger;
import org.jetbrains.bio.npy.LongArrayChunker;
import org.jetbrains.bio.npy.LongArrayMerger;
import org.jetbrains.bio.npy.NpyArray;
import org.jetbrains.bio.npy.NpyFile;
import org.jetbrains.bio.npy.NpyKt;
import org.jetbrains.bio.npy.PeekingIterator;
import org.jetbrains.bio.npy.ShortArrayChunker;
import org.jetbrains.bio.npy.ShortArrayMerger;
import org.jetbrains.bio.npy.StringArrayChunker;
import org.jetbrains.bio.npy.StringArrayMerger;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\u0010\u0012\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0016\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u000bJ+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u000bJ+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u000bJ+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u000bJ+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u000bJ\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007J\u001b\u0010\u0015\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0002\b\u001cJ-\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u001fJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\r2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u000e2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u000f2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00122\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00132\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00142\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/bio/npy/NpyFile;", "", "()V", "allocate", "Lkotlin/sequences/Sequence;", "Ljava/nio/ByteBuffer;", "data", "", "", "shape", "", "allocate$npy_main", "([Ljava/lang/String;[I)Lkotlin/sequences/Sequence;", "", "", "", "order", "Ljava/nio/ByteOrder;", "", "", "", "read", "Lorg/jetbrains/bio/npy/NpyArray;", "path", "Ljava/nio/file/Path;", "step", "", "chunks", "read$npy_main", "write", "", "(Ljava/nio/file/Path;[Ljava/lang/String;[I)V", "Header", "npy_main"})
public final class NpyFile {
    public static final NpyFile INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final NpyArray read(@NotNull Path path, int step) {
        Closeable closeable;
        NpyArray npyArray;
        Intrinsics.checkParameterIsNotNull(path, "path");
        Closeable closeable2 = FileChannel.open(path, new OpenOption[0]);
        boolean bl = false;
        try {
            void chunk;
            void remaining;
            FileChannel it = (FileChannel)closeable2;
            Ref.LongRef longRef = new Ref.LongRef();
            longRef.element = Files.size(path);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = ByteBuffer.allocate(0);
            objectRef = null;
            longRef = null;
            npyArray = INSTANCE.read$npy_main(SequencesKt.generateSequence((Function0)new Function0<ByteBuffer>((Ref.LongRef)remaining, (Ref.ObjectRef)chunk, it, path, step){
                final /* synthetic */ Ref.LongRef $remaining;
                final /* synthetic */ Ref.ObjectRef $chunk;
                final /* synthetic */ FileChannel $it;
                final /* synthetic */ Path $path$inlined;
                final /* synthetic */ int $step$inlined;
                {
                    this.$remaining = longRef;
                    this.$chunk = objectRef;
                    this.$it = fileChannel;
                    this.$path$inlined = path;
                    this.$step$inlined = n;
                    super(0);
                }

                public final ByteBuffer invoke() {
                    ByteBuffer byteBuffer;
                    this.$remaining.element += (long)((ByteBuffer)this.$chunk.element).remaining();
                    if (this.$remaining.element == 0L) {
                        byteBuffer = null;
                    } else {
                        long offset = Files.size(this.$path$inlined) - this.$remaining.element;
                        this.$chunk.element = this.$it.map(FileChannel.MapMode.READ_ONLY, offset, this.$remaining.element > (long)this.$step$inlined ? (long)this.$step$inlined : this.$remaining.element);
                        this.$remaining.element -= (long)((ByteBuffer)this.$chunk.element).capacity();
                        byteBuffer = (ByteBuffer)this.$chunk.element;
                    }
                    return byteBuffer;
                }
            }));
            closeable = closeable2;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    Closeable closeable3 = closeable2;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    Closeable closeable4 = closeable2;
                    if (closeable4 != null) {
                        closeable4.close();
                    }
                }
                throw throwable;
            }
        }
        if (closeable != null) {
            closeable.close();
        }
        return npyArray;
    }

    @JvmStatic
    @NotNull
    public static /* bridge */ /* synthetic */ NpyArray read$default(Path path, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return NpyFile.read(path, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NpyArray read$npy_main(@NotNull Sequence<? extends ByteBuffer> chunks) {
        Iterator iterator2;
        ArrayMerger arrayMerger;
        int[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull(chunks, "chunks");
        PeekingIterator<? extends ByteBuffer> it = new PeekingIterator<ByteBuffer>(chunks.iterator());
        Header header = Header.Companion.read(it.peek());
        int[] nArray = $receiver$iv = header.getShape();
        if (nArray.length == 0) {
            throw (Throwable)new UnsupportedOperationException("Empty array can't be reduced.");
        }
        int accumulator$iv2 = $receiver$iv[0];
        int n = 1;
        int n2 = ArraysKt.getLastIndex($receiver$iv);
        if (n <= n2) {
            while (true) {
                void b;
                void index$iv;
                int n3 = $receiver$iv[index$iv];
                int a = accumulator$iv2;
                accumulator$iv2 = a * b;
                if (index$iv == n2) break;
                ++index$iv;
            }
        }
        int size = accumulator$iv2;
        block0 : switch (header.getType()) {
            case 'b': {
                int n4 = accumulator$iv2 = header.getBytes() == 1 ? 1 : 0;
                if (accumulator$iv2 == 0) {
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                arrayMerger = new BooleanArrayMerger(size);
                break;
            }
            case 'i': 
            case 'u': {
                switch (header.getBytes()) {
                    case 1: {
                        arrayMerger = new ByteArrayMerger(size);
                        break block0;
                    }
                    case 2: {
                        arrayMerger = new ShortArrayMerger(size);
                        break block0;
                    }
                    case 4: {
                        arrayMerger = new IntArrayMerger(size);
                        break block0;
                    }
                    case 8: {
                        arrayMerger = new LongArrayMerger(size);
                        break block0;
                    }
                }
                String accumulator$iv2 = "invalid number of bytes for " + header.getType() + ": " + header.getBytes();
                throw (Throwable)new IllegalStateException(accumulator$iv2.toString());
            }
            case 'f': {
                switch (header.getBytes()) {
                    case 4: {
                        arrayMerger = new FloatArrayMerger(size);
                        break block0;
                    }
                    case 8: {
                        arrayMerger = new DoubleArrayMerger(size);
                        break block0;
                    }
                }
                String accumulator$iv2 = "invalid number of bytes for " + header.getType() + ": " + header.getBytes();
                throw (Throwable)new IllegalStateException(accumulator$iv2.toString());
            }
            case 'S': {
                arrayMerger = new StringArrayMerger(size, header.getBytes());
                break;
            }
            default: {
                String accumulator$iv2 = "unsupported type: " + header.getType();
                throw (Throwable)new IllegalStateException(accumulator$iv2.toString());
            }
        }
        ArrayMerger merger = arrayMerger;
        Iterator iterator3 = iterator2 = (Iterator)it;
        while (iterator3.hasNext()) {
            ByteBuffer chunk = (ByteBuffer)iterator3.next();
            chunk.order(header.getOrder());
            merger.invoke(chunk);
        }
        return new NpyArray(merger.result(), header.getShape());
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull boolean[] data, @NotNull int[] shape) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        INSTANCE.write(path, INSTANCE.allocate$npy_main(data, shape));
    }

    @JvmStatic
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void write$default(Path path, boolean[] blArray, int[] nArray, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{blArray.length};
        }
        NpyFile.write(path, blArray, nArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull boolean[] data) {
        NpyFile.write$default(path, data, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull byte[] data, @NotNull int[] shape) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        INSTANCE.write(path, INSTANCE.allocate$npy_main(data, shape));
    }

    @JvmStatic
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void write$default(Path path, byte[] byArray, int[] nArray, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{byArray.length};
        }
        NpyFile.write(path, byArray, nArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull byte[] data) {
        NpyFile.write$default(path, data, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull short[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Intrinsics.checkParameterIsNotNull(order, "order");
        INSTANCE.write(path, INSTANCE.allocate$npy_main(data, shape, order));
    }

    @JvmStatic
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void write$default(Path path, short[] sArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{sArray.length};
        }
        if ((n & 8) != 0) {
            ByteOrder byteOrder2 = ByteOrder.nativeOrder();
            Intrinsics.checkExpressionValueIsNotNull(byteOrder2, "ByteOrder.nativeOrder()");
            byteOrder = byteOrder2;
        }
        NpyFile.write(path, sArray, nArray, byteOrder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull short[] data, @NotNull int[] shape) {
        NpyFile.write$default(path, data, shape, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull short[] data) {
        NpyFile.write$default(path, data, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull int[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Intrinsics.checkParameterIsNotNull(order, "order");
        INSTANCE.write(path, INSTANCE.allocate$npy_main(data, shape, order));
    }

    @JvmStatic
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void write$default(Path path, int[] nArray, int[] nArray2, ByteOrder byteOrder, int n, Object object) {
        if ((n & 4) != 0) {
            nArray2 = new int[]{nArray.length};
        }
        if ((n & 8) != 0) {
            ByteOrder byteOrder2 = ByteOrder.nativeOrder();
            Intrinsics.checkExpressionValueIsNotNull(byteOrder2, "ByteOrder.nativeOrder()");
            byteOrder = byteOrder2;
        }
        NpyFile.write(path, nArray, nArray2, byteOrder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull int[] data, @NotNull int[] shape) {
        NpyFile.write$default(path, data, shape, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull int[] data) {
        NpyFile.write$default(path, data, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull long[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Intrinsics.checkParameterIsNotNull(order, "order");
        INSTANCE.write(path, INSTANCE.allocate$npy_main(data, shape, order));
    }

    @JvmStatic
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void write$default(Path path, long[] lArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{lArray.length};
        }
        if ((n & 8) != 0) {
            ByteOrder byteOrder2 = ByteOrder.nativeOrder();
            Intrinsics.checkExpressionValueIsNotNull(byteOrder2, "ByteOrder.nativeOrder()");
            byteOrder = byteOrder2;
        }
        NpyFile.write(path, lArray, nArray, byteOrder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull long[] data, @NotNull int[] shape) {
        NpyFile.write$default(path, data, shape, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull long[] data) {
        NpyFile.write$default(path, data, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull float[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Intrinsics.checkParameterIsNotNull(order, "order");
        INSTANCE.write(path, INSTANCE.allocate$npy_main(data, shape, order));
    }

    @JvmStatic
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void write$default(Path path, float[] fArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{fArray.length};
        }
        if ((n & 8) != 0) {
            ByteOrder byteOrder2 = ByteOrder.nativeOrder();
            Intrinsics.checkExpressionValueIsNotNull(byteOrder2, "ByteOrder.nativeOrder()");
            byteOrder = byteOrder2;
        }
        NpyFile.write(path, fArray, nArray, byteOrder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull float[] data, @NotNull int[] shape) {
        NpyFile.write$default(path, data, shape, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull float[] data) {
        NpyFile.write$default(path, data, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull double[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Intrinsics.checkParameterIsNotNull(order, "order");
        INSTANCE.write(path, INSTANCE.allocate$npy_main(data, shape, order));
    }

    @JvmStatic
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void write$default(Path path, double[] dArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{dArray.length};
        }
        if ((n & 8) != 0) {
            ByteOrder byteOrder2 = ByteOrder.nativeOrder();
            Intrinsics.checkExpressionValueIsNotNull(byteOrder2, "ByteOrder.nativeOrder()");
            byteOrder = byteOrder2;
        }
        NpyFile.write(path, dArray, nArray, byteOrder);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull double[] data, @NotNull int[] shape) {
        NpyFile.write$default(path, data, shape, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull double[] data) {
        NpyFile.write$default(path, data, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull String[] data, @NotNull int[] shape) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        INSTANCE.write(path, INSTANCE.allocate$npy_main(data, shape));
    }

    @JvmStatic
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void write$default(Path path, String[] stringArray, int[] nArray, int n, Object object) {
        if ((n & 4) != 0) {
            nArray = new int[]{((Object[])stringArray).length};
        }
        NpyFile.write(path, stringArray, nArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Path path, @NotNull String[] data) {
        NpyFile.write$default(path, data, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void write(Path path, Sequence<? extends ByteBuffer> chunks) {
        Closeable closeable;
        Closeable closeable2 = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        boolean bl = false;
        try {
            FileChannel it = (FileChannel)closeable2;
            Iterator<? extends ByteBuffer> iterator2 = chunks.iterator();
            while (iterator2.hasNext()) {
                ByteBuffer chunk = iterator2.next();
                while (chunk.hasRemaining()) {
                    it.write(chunk);
                }
            }
            FileChannel fileChannel = it.truncate(it.position());
            closeable = closeable2;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    Closeable closeable3 = closeable2;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    Closeable closeable4 = closeable2;
                    if (closeable4 != null) {
                        closeable4.close();
                    }
                }
                throw throwable;
            }
        }
        if (closeable != null) {
            closeable.close();
        }
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy_main(@NotNull boolean[] data, @NotNull int[] shape) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Header header = new Header(null, 'b', 1, shape);
        return SequencesKt.plus(SequencesKt.sequenceOf(header.allocate$npy_main()), new BooleanArrayChunker(data));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy_main(@NotNull byte[] data, @NotNull int[] shape) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Header header = new Header(null, 'i', 1, shape);
        return SequencesKt.plus(SequencesKt.sequenceOf(header.allocate$npy_main()), ByteBuffer.wrap(data));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy_main(@NotNull short[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Intrinsics.checkParameterIsNotNull(order, "order");
        Header header = new Header(order, 'i', 2, shape);
        return SequencesKt.plus(SequencesKt.sequenceOf(header.allocate$npy_main()), new ShortArrayChunker(data, order));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy_main(@NotNull int[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Intrinsics.checkParameterIsNotNull(order, "order");
        Header header = new Header(order, 'i', 4, shape);
        return SequencesKt.plus(SequencesKt.sequenceOf(header.allocate$npy_main()), new IntArrayChunker(data, order));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy_main(@NotNull long[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Intrinsics.checkParameterIsNotNull(order, "order");
        Header header = new Header(order, 'i', 8, shape);
        return SequencesKt.plus(SequencesKt.sequenceOf(header.allocate$npy_main()), new LongArrayChunker(data, order));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy_main(@NotNull float[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Intrinsics.checkParameterIsNotNull(order, "order");
        Header header = new Header(order, 'f', 4, shape);
        return SequencesKt.plus(SequencesKt.sequenceOf(header.allocate$npy_main()), new FloatArrayChunker(data, order));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy_main(@NotNull double[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Intrinsics.checkParameterIsNotNull(order, "order");
        Header header = new Header(order, 'f', 8, shape);
        return SequencesKt.plus(SequencesKt.sequenceOf(header.allocate$npy_main()), new DoubleArrayChunker(data, order));
    }

    @NotNull
    public final Sequence<ByteBuffer> allocate$npy_main(@NotNull String[] data, @NotNull int[] shape) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        Integer n = (Integer)SequencesKt.max(SequencesKt.map(ArraysKt.asSequence((Object[])data), allocate.bytes.1.INSTANCE));
        int bytes2 = n != null ? n : 0;
        Header header = new Header(null, 'S', bytes2, shape);
        return SequencesKt.plus(SequencesKt.sequenceOf(header.allocate$npy_main()), new StringArrayChunker(data));
    }

    private NpyFile() {
        INSTANCE = this;
    }

    static {
        new NpyFile();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0080\b\u0018\u0000 '2\u00020\u0001:\u0001'B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aH\u0000\u00a2\u0006\u0002\b\u001cJ\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J3\u0010!\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010%\u001a\u00020\u0007H\u0016J\t\u0010&\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lorg/jetbrains/bio/npy/NpyFile$Header;", "", "order", "Ljava/nio/ByteOrder;", "type", "", "bytes", "", "shape", "", "(Ljava/nio/ByteOrder;CI[I)V", "getBytes", "()I", "major", "getMajor", "meta", "", "minor", "getOrder", "()Ljava/nio/ByteOrder;", "getShape", "()[I", "size", "getType", "()C", "allocate", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "allocate$npy_main", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "npy_main"})
    public static final class Header {
        private final int major;
        private final int minor = 0;
        private final String meta;
        private final int size;
        @Nullable
        private final ByteOrder order;
        private final char type;
        private final int bytes;
        @NotNull
        private final int[] shape;
        @NotNull
        private static final byte[] MAGIC;
        private static int NPY_10_20_SIZE_BOUNDARY;
        public static final Companion Companion;

        public final int getMajor() {
            return this.major;
        }

        public final ByteBuffer allocate$npy_main() {
            ByteBuffer byteBuffer;
            ByteBuffer $receiver = byteBuffer = ByteBuffer.allocateDirect(this.size);
            $receiver.order(ByteOrder.LITTLE_ENDIAN);
            $receiver.put(Companion.getMAGIC$npy_main());
            $receiver.put((byte)this.major);
            $receiver.put((byte)this.minor);
            Object object = TuplesKt.to(this.major, this.minor);
            if (Intrinsics.areEqual(object, TuplesKt.to(1, 0))) {
                $receiver.putShort((short)this.meta.length());
            } else if (Intrinsics.areEqual(object, TuplesKt.to(2, 0))) {
                $receiver.putInt(this.meta.length());
            }
            object = this.meta;
            Charset charset = Charsets.US_ASCII;
            ByteBuffer byteBuffer2 = $receiver;
            Object object2 = object;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = ((String)object2).getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            byteBuffer2.put(byArray2);
            $receiver.rewind();
            return byteBuffer;
        }

        public boolean equals(@Nullable Object other) {
            return this == other ? true : (other == null || !(other instanceof Header) ? false : Intrinsics.areEqual(this.order, ((Header)other).order) && this.type == ((Header)other).type && this.bytes == ((Header)other).bytes && Arrays.equals(this.shape, ((Header)other).shape));
        }

        public int hashCode() {
            return Objects.hash(this.order, Character.valueOf(this.type), this.bytes, Arrays.hashCode(this.shape));
        }

        @Nullable
        public final ByteOrder getOrder() {
            return this.order;
        }

        public final char getType() {
            return this.type;
        }

        public final int getBytes() {
            return this.bytes;
        }

        @NotNull
        public final int[] getShape() {
            return this.shape;
        }

        public Header(@Nullable ByteOrder order, char type, int bytes2, @NotNull int[] shape) {
            Intrinsics.checkParameterIsNotNull(shape, "shape");
            this.order = order;
            this.type = type;
            this.bytes = bytes2;
            this.shape = shape;
            String metaUnpadded = new StringJoiner(", ", "{", "}").add("'descr': '" + NpyKt.access$toChar(this.order) + this.type + this.bytes + "'").add("'fortran_order': False").add("'shape': (" + ArraysKt.joinToString$default(this.shape, (CharSequence)",", null, null, 0, null, null, 62, null) + ", )").toString();
            int totalUnpadded = Companion.getMAGIC$npy_main().length + 2 + 2 + metaUnpadded.length() + 1;
            int padding = 16 - totalUnpadded % 16;
            int total = totalUnpadded + padding;
            if (total <= Companion.getNPY_10_20_SIZE_BOUNDARY$npy_main()) {
                this.major = 1;
            } else {
                total += 2;
                this.major = 2;
            }
            this.meta = metaUnpadded + StringsKt.repeat(" ", padding) + '\n';
            this.size = total;
        }

        public /* synthetic */ Header(ByteOrder byteOrder, char c, int n, int[] nArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                byteOrder = null;
            }
            this(byteOrder, c, n, nArray);
        }

        static {
            Companion = new Companion(null);
            String string = "NUMPY";
            Charset charset = null;
            boolean bl = true;
            Object var3_3 = null;
            byte[] byArray = new byte[]{(byte)147};
            if (bl & true) {
                charset = Charsets.UTF_8;
            }
            byte[] byArray2 = string.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull(byArray2, "(this as java.lang.String).getBytes(charset)");
            byte[] byArray3 = byArray2;
            MAGIC = ArraysKt.plus(byArray, byArray3);
            NPY_10_20_SIZE_BOUNDARY = 65535;
        }

        @Nullable
        public final ByteOrder component1() {
            return this.order;
        }

        public final char component2() {
            return this.type;
        }

        public final int component3() {
            return this.bytes;
        }

        @NotNull
        public final int[] component4() {
            return this.shape;
        }

        @NotNull
        public final Header copy(@Nullable ByteOrder order, char type, int bytes2, @NotNull int[] shape) {
            Intrinsics.checkParameterIsNotNull(shape, "shape");
            return new Header(order, type, bytes2, shape);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Header copy$default(Header header, ByteOrder byteOrder, char c, int n, int[] nArray, int n2, Object object) {
            if ((n2 & 1) != 0) {
                byteOrder = header.order;
            }
            if ((n2 & 2) != 0) {
                c = header.type;
            }
            if ((n2 & 4) != 0) {
                n = header.bytes;
            }
            if ((n2 & 8) != 0) {
                nArray = header.shape;
            }
            return header.copy(byteOrder, c, n, nArray);
        }

        public String toString() {
            return "Header(order=" + this.order + ", type=" + this.type + ", bytes=" + this.bytes + ", shape=" + Arrays.toString(this.shape) + ")";
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/bio/npy/NpyFile$Header$Companion;", "", "()V", "MAGIC", "", "getMAGIC$npy_main", "()[B", "NPY_10_20_SIZE_BOUNDARY", "", "getNPY_10_20_SIZE_BOUNDARY$npy_main", "()I", "setNPY_10_20_SIZE_BOUNDARY$npy_main", "(I)V", "read", "Lorg/jetbrains/bio/npy/NpyFile$Header;", "input", "Ljava/nio/ByteBuffer;", "npy_main"})
        public static final class Companion {
            @NotNull
            public final byte[] getMAGIC$npy_main() {
                return MAGIC;
            }

            public final int getNPY_10_20_SIZE_BOUNDARY$npy_main() {
                return NPY_10_20_SIZE_BOUNDARY;
            }

            public final void setNPY_10_20_SIZE_BOUNDARY$npy_main(int n) {
                NPY_10_20_SIZE_BOUNDARY = n;
            }

            @NotNull
            public final Header read(@NotNull ByteBuffer input) {
                String string;
                Header header;
                boolean bl;
                int n;
                ByteBuffer byteBuffer;
                Intrinsics.checkParameterIsNotNull(input, "input");
                ByteBuffer $receiver = byteBuffer = input.order(ByteOrder.LITTLE_ENDIAN);
                byte[] buf = new byte[6];
                $receiver.get(buf);
                boolean bl2 = Arrays.equals(Companion.getMAGIC$npy_main(), buf);
                if (!bl2) {
                    byte[] byArray = buf;
                    CharSequence charSequence = new StringBuilder().append("bad magic: ");
                    String string2 = new String(byArray, Charsets.UTF_8);
                    charSequence = ((StringBuilder)charSequence).append(string2).toString();
                    throw (Throwable)new IllegalStateException(((Object)charSequence).toString());
                }
                byte major = $receiver.get();
                byte minor = $receiver.get();
                Pair<Integer, Integer> pair = TuplesKt.to(Integer.valueOf(major), Integer.valueOf(minor));
                if (Intrinsics.areEqual(pair, TuplesKt.to(1, 0))) {
                    n = $receiver.getShort();
                } else if (Intrinsics.areEqual(pair, TuplesKt.to(2, 0))) {
                    n = $receiver.getInt();
                } else {
                    String $i$a$1$check = "unsupported version: " + major + "." + minor;
                    throw (Throwable)new IllegalStateException($i$a$1$check.toString());
                }
                int size = n;
                byte[] header2 = new byte[size];
                $receiver.get(header2);
                String s = new String(header2, Charsets.UTF_8);
                Map<String, Object> meta = DictParserKt.parseDict(s);
                Object object = meta.get("descr");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                String type = (String)object;
                Object object2 = meta.get("fortran_order");
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                }
                boolean bl3 = bl = (Boolean)object2 == false;
                if (!bl) {
                    String string3 = "Fortran-contiguous arrays are not supported";
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                Object object3 = meta.get("shape");
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Int>");
                }
                int[] shape = CollectionsKt.toIntArray((List)object3);
                ByteOrder order = NpyKt.access$toByteOrder(type.charAt(0));
                String string4 = type;
                int n2 = 2;
                char c = type.charAt(1);
                ByteOrder byteOrder = order;
                Header header3 = header;
                Header header4 = header;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2);
                Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.String).substring(startIndex)");
                string4 = string = string6;
                int n3 = Integer.parseInt(string4);
                header3(byteOrder, c, n3, shape);
                return header4;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

