/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.dnd.AbstractGhostDropManager;
import org.broad.igv.ui.dnd.GhostDropEvent;
import org.broad.igv.ui.dnd.GhostDropListener;
import org.broad.igv.ui.dnd.GhostGlassPane;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelComponent;
import org.broad.igv.ui.util.UIUtilities;
import org.jdesktop.layout.GroupLayout;

public class TrackNamePanel
extends TrackPanelComponent
implements Paintable {
    private static Logger log = Logger.getLogger(TrackNamePanel.class);
    List<GroupExtent> groupExtents = new ArrayList<GroupExtent>();
    BufferedImage dndImage = null;
    TrackGroup selectedGroup = null;
    boolean showGroupNames = true;
    boolean showSampleNamesWhenGrouped = false;
    static List<DropListener> dropListeners = new ArrayList<DropListener>();

    public TrackNamePanel(TrackPanel trackPanel) {
        super(trackPanel);
        this.init();
    }

    Collection<TrackGroup> getGroups() {
        return this.getTrackPanel().getGroups();
    }

    private boolean isGrouped() {
        return this.getGroups().size() > 1;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (PreferencesManager.getPreferences().getAntiAliasing()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.removeMousableRegions();
        Rectangle visibleRect = this.getVisibleRect();
        this.paintImpl(g, visibleRect);
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect) {
        g.setColor(Color.white);
        g.fill(rect);
        this.paintImpl(g, rect);
        Color c = g.getColor();
        g.setColor(Color.darkGray);
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(c);
    }

    private void paintImpl(Graphics g, Rectangle visibleRect) {
        boolean isGrouped;
        Collection<TrackGroup> groups2 = this.getGroups();
        boolean bl = isGrouped = groups2.size() > 1;
        if (!groups2.isEmpty()) {
            Graphics2D graphics2D = (Graphics2D)g;
            graphics2D.setColor(Color.BLACK);
            Graphics2D greyGraphics = (Graphics2D)g.create();
            greyGraphics.setColor(UIConstants.LIGHT_GREY);
            int regionY = 0;
            this.groupExtents.clear();
            for (TrackGroup group : groups2) {
                if ((double)regionY > visibleRect.getMaxY()) break;
                if (!group.isVisible()) continue;
                if (isGrouped) {
                    if (regionY + 10 >= visibleRect.y && (double)regionY < visibleRect.getMaxY()) {
                        greyGraphics.fillRect(0, regionY + 1, this.getWidth(), 9);
                    }
                    regionY += 10;
                }
                if (group.isDrawBorder() && regionY + 10 >= visibleRect.y && (double)regionY < visibleRect.getMaxY()) {
                    g.drawLine(0, regionY - 1, this.getWidth(), regionY - 1);
                }
                int h = group.getHeight();
                Rectangle groupRect = new Rectangle(visibleRect.x, regionY, visibleRect.width, h);
                Rectangle displayableRect = this.getDisplayableRect(groupRect, visibleRect);
                regionY = this.printTrackNames(group, displayableRect, visibleRect, graphics2D, 0, regionY);
                if (isGrouped) {
                    this.groupExtents.add(new GroupExtent(group, groupRect.y, groupRect.y + groupRect.height));
                    if (this.showGroupNames) {
                        group.renderName(graphics2D, displayableRect, group == this.selectedGroup);
                    }
                }
                if (!group.isDrawBorder()) continue;
                g.drawLine(0, regionY, this.getWidth(), regionY);
            }
            graphics2D.dispose();
            greyGraphics.dispose();
        }
    }

    private Rectangle getDisplayableRect(Rectangle trackRectangle, Rectangle visibleRect) {
        Rectangle rect = null;
        if (visibleRect != null) {
            Rectangle intersectedRect = trackRectangle.intersection(visibleRect);
            rect = intersectedRect.height > 15 ? intersectedRect : new Rectangle(trackRectangle);
        }
        return rect;
    }

    private int printTrackNames(TrackGroup group, Rectangle visibleRect, Rectangle clipRect, Graphics2D graphics2D, int regionX, int regionY) {
        ArrayList<Track> tmp = new ArrayList<Track>(group.getVisibleTracks());
        Color backgroundColor = PreferencesManager.getPreferences().getAsColor("BACKGROUND_COLOR");
        graphics2D.setBackground(backgroundColor);
        graphics2D.clearRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
        for (Track track : tmp) {
            if (track == null) continue;
            track.setY(regionY);
            int trackHeight = track.getHeight();
            if (!track.isVisible()) continue;
            if (regionY + trackHeight >= clipRect.y && (double)regionY < clipRect.getMaxY()) {
                int width = this.getWidth();
                int height = track.getHeight();
                Rectangle region = new Rectangle(regionX, regionY, width, height);
                this.addMousableRegion(new MouseableRegion(region, track));
                if (!this.isGrouped() || this.showSampleNamesWhenGrouped) {
                    Rectangle rect = new Rectangle(regionX, regionY, width, height);
                    if (track.isSelected()) {
                        graphics2D.setBackground(Color.LIGHT_GRAY);
                        graphics2D.clearRect(rect.x, rect.y, rect.width, rect.height);
                    } else {
                        graphics2D.setBackground(backgroundColor);
                    }
                    Graphics2D trackGraphics = (Graphics2D)graphics2D.create();
                    track.renderName(trackGraphics, rect, visibleRect);
                    trackGraphics.dispose();
                }
            }
            regionY += trackHeight;
        }
        return regionY;
    }

    private void init() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setBackground(new Color(255, 255, 255));
        GroupLayout dataTrackNamePanelLayout = new GroupLayout(this);
        this.setLayout(dataTrackNamePanelLayout);
        dataTrackNamePanelLayout.setHorizontalGroup(dataTrackNamePanelLayout.createParallelGroup(1).add(0, 148, Short.MAX_VALUE));
        dataTrackNamePanelLayout.setVerticalGroup(dataTrackNamePanelLayout.createParallelGroup(1).add(0, 528, Short.MAX_VALUE));
        NamePanelMouseAdapter mouseAdapter = new NamePanelMouseAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        DropListener dndListener = new DropListener(this);
        TrackNamePanel.addGhostDropListener(dndListener);
    }

    @Override
    protected void openPopupMenu(TrackClickEvent te) {
        ArrayList<Component> extraItems = null;
        if (this.isGrouped()) {
            extraItems = new ArrayList<Component>();
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show group names");
            item.setSelected(this.showGroupNames);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackNamePanel.this.showGroupNames = item.isSelected();
                    TrackNamePanel.this.repaint();
                }
            });
            extraItems.add(item);
            final JCheckBoxMenuItem item2 = new JCheckBoxMenuItem("Show sample names");
            item2.setSelected(this.showSampleNamesWhenGrouped);
            item2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackNamePanel.this.showSampleNamesWhenGrouped = item2.isSelected();
                    TrackNamePanel.this.repaint();
                }
            });
            extraItems.add(item2);
        }
        super.openPopupMenu(te, extraItems);
    }

    public String getTooltipTextForLocation(int x, int y) {
        List<MouseableRegion> mouseableRegions = this.getMouseRegions();
        String text = null;
        for (MouseableRegion mouseableRegion : mouseableRegions) {
            if (!mouseableRegion.containsPoint(x, y)) continue;
            Set<Track> tracks = mouseableRegion.getTracks();
            if (tracks != null && tracks.size() == 1) {
                Track track = (Track)tracks.iterator().next();
                text = track.getNameValueString(y);
                break;
            }
            text = mouseableRegion.getText();
            break;
        }
        return text;
    }

    private synchronized void createDnDImage() {
        this.dndImage = new BufferedImage(this.getWidth(), 2, 2);
        Graphics g = this.dndImage.getGraphics();
        g.setColor(Color.blue);
        g.drawLine(1, 0, this.getWidth() - 2, 0);
        g.drawLine(1, 1, this.getWidth() - 2, 1);
    }

    protected void shiftSelectTracks(MouseEvent e) {
        for (MouseableRegion mouseRegion : this.mouseRegions) {
            if (!mouseRegion.containsPoint(e.getX(), e.getY())) continue;
            Set<Track> clickedTracks = mouseRegion.getTracks();
            if (clickedTracks != null && clickedTracks.size() > 0) {
                Track t = (Track)clickedTracks.iterator().next();
                IGV.getInstance().shiftSelectTracks(t);
            }
            return;
        }
    }

    private TrackGroup getGroup(int y) {
        for (GroupExtent ge : this.groupExtents) {
            if (!ge.contains(y)) continue;
            return ge.group;
        }
        return null;
    }

    private void selectGroup(TrackGroup group) {
        this.selectedGroup = group;
        if (this.selectedGroup != null) {
            for (Track t : this.selectedGroup.getVisibleTracks()) {
                t.setSelected(true);
            }
        }
    }

    int getGroupGapNumber(int y) {
        for (int i = 0; i < this.groupExtents.size(); ++i) {
            if (!this.groupExtents.get(i).isAfter(y)) continue;
            return i;
        }
        return this.groupExtents.size();
    }

    private static void addGhostDropListener(DropListener listener) {
        if (listener != null) {
            dropListeners.add(listener);
        }
    }

    public static void removeDropListenerFor(TrackNamePanel panel) {
        ArrayList<DropListener> removeThese = new ArrayList<DropListener>();
        for (DropListener dl : dropListeners) {
            if (dl.panel != panel) continue;
            removeThese.add(dl);
        }
        dropListeners.removeAll(removeThese);
    }

    class GroupExtent {
        TrackGroup group;
        int minY;
        int maxY;

        GroupExtent(TrackGroup group, int minY, int maxY) {
            this.group = group;
            this.maxY = maxY;
            this.minY = minY;
        }

        boolean contains(int y) {
            return y > this.minY && y <= this.maxY;
        }

        boolean isAfter(int y) {
            return this.minY > y;
        }
    }

    class DropListener
    extends AbstractGhostDropManager {
        TrackNamePanel panel;

        public DropListener(TrackNamePanel target) {
            super(target);
            this.panel = target;
        }

        @Override
        public void ghostDropped(GhostDropEvent e) {
            boolean isInTarget;
            Point startPoint = e.getStartLocation();
            Point dropPoint = this.getTranslatedPoint(e.getDropLocation());
            Rectangle bounds = this.component.getVisibleRect();
            boolean bl = isInTarget = dropPoint.y > bounds.y && (double)dropPoint.y < bounds.getMaxY();
            if (isInTarget) {
                this.tracksDropped(startPoint, dropPoint, e.getTracks());
                e.removeTracksFromSource();
                e.setTracksDropped(true);
            } else {
                TrackPanel view = (TrackPanel)TrackNamePanel.this.getParent();
                if (e.isTracksDropped()) {
                    view.removeTracks(e.getTracks());
                } else {
                    e.addSourcePanel(view);
                }
            }
        }

        void tracksDropped(Point startPoint, Point dropPoint, List<Track> tracks) {
            TrackPanel panel = (TrackPanel)TrackNamePanel.this.getParent();
            List<MouseableRegion> regions = TrackNamePanel.this.getMouseRegions();
            if (regions.isEmpty()) {
                panel.addTracks(tracks);
            } else {
                Iterator<Track> tmp;
                boolean before = true;
                MouseableRegion dropRegion = null;
                MouseableRegion startRegion = null;
                for (MouseableRegion region : regions) {
                    if (region.containsPoint(dropPoint.x, dropPoint.y)) {
                        dropRegion = region;
                        Rectangle bnds = dropRegion.getBounds();
                        int dy1 = dropPoint.y - bnds.y;
                        int dy2 = bnds.height - dy1;
                        boolean bl = before = dy1 < dy2;
                    }
                    if (region.containsPoint(startPoint.x, startPoint.y)) {
                        startRegion = region;
                    }
                    if (dropRegion == null || startRegion == null) continue;
                    break;
                }
                Track dropTrack = null;
                if (dropRegion != null && (tmp = dropRegion.getTracks().iterator()).hasNext()) {
                    dropTrack = tmp.next();
                }
                panel.moveSelectedTracksTo(tracks, dropTrack, before);
            }
        }
    }

    class NamePanelMouseAdapter
    extends MouseInputAdapter {
        boolean isDragging = false;
        List<Track> dragTracks = new ArrayList<Track>();
        Point dragStart = null;

        NamePanelMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dragStart = e.getPoint();
            TrackNamePanel.this.requestFocus();
            TrackNamePanel.this.grabFocus();
            boolean isGrouped = TrackNamePanel.this.isGrouped();
            if (e.isPopupTrigger()) {
                if (isGrouped) {
                    TrackNamePanel.this.clearTrackSelections();
                    TrackGroup g = TrackNamePanel.this.getGroup(e.getY());
                    if (null == g || g == TrackNamePanel.this.selectedGroup) {
                        TrackNamePanel.this.selectedGroup = null;
                    } else {
                        TrackNamePanel.this.selectGroup(g);
                    }
                } else if (!TrackNamePanel.this.isTrackSelected(e)) {
                    TrackNamePanel.this.clearTrackSelections();
                    TrackNamePanel.this.selectTracks(e);
                }
                TrackClickEvent te = new TrackClickEvent(e, null);
                TrackNamePanel.this.openPopupMenu(te);
            } else if (e.getButton() == 1) {
                if (isGrouped) {
                    TrackNamePanel.this.clearTrackSelections();
                    TrackGroup g = TrackNamePanel.this.getGroup(e.getY());
                    if (g == TrackNamePanel.this.selectedGroup) {
                        TrackNamePanel.this.selectedGroup = null;
                    } else {
                        TrackNamePanel.this.selectGroup(TrackNamePanel.this.getGroup(e.getY()));
                    }
                } else if (e.isMetaDown() || e.isControlDown()) {
                    TrackNamePanel.this.toggleTrackSelections(e);
                } else if (e.isShiftDown()) {
                    TrackNamePanel.this.shiftSelectTracks(e);
                } else if (!TrackNamePanel.this.isTrackSelected(e)) {
                    TrackNamePanel.this.clearTrackSelections();
                    TrackNamePanel.this.selectTracks(e);
                }
            } else if (!isGrouped && !TrackNamePanel.this.isTrackSelected(e)) {
                TrackNamePanel.this.clearTrackSelections();
                TrackNamePanel.this.selectTracks(e);
            }
            IGV.getInstance().repaintNamePanels();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (log.isTraceEnabled()) {
                log.trace("Enter mouseReleased");
            }
            if (this.isDragging) {
                Component c = e.getComponent();
                IGV.getInstance().endDnD();
                GhostGlassPane glassPane = IGV.getInstance().getDnDGlassPane();
                Point p = (Point)e.getPoint().clone();
                SwingUtilities.convertPointToScreen(p, c);
                Point eventPoint = (Point)p.clone();
                SwingUtilities.convertPointFromScreen(p, glassPane);
                glassPane.setPoint(p);
                glassPane.setVisible(false);
                glassPane.setImage(null);
                this.fireGhostDropEvent(new GhostDropEvent(this.dragStart, eventPoint, this.dragTracks));
                if (TrackNamePanel.this.selectedGroup != null) {
                    int idx = TrackNamePanel.this.getGroupGapNumber(e.getY());
                    TrackPanel dataTrackView = (TrackPanel)TrackNamePanel.this.getParent();
                    dataTrackView.moveGroup(TrackNamePanel.this.selectedGroup, idx);
                    dataTrackView.repaint();
                }
                TrackNamePanel.this.selectedGroup = null;
            }
            if (e.isPopupTrigger()) {
                TrackClickEvent te = new TrackClickEvent(e, null);
                TrackNamePanel.this.openPopupMenu(te);
            } else if (!(this.isDragging || e.isMetaDown() || e.isControlDown() || e.isShiftDown())) {
                TrackNamePanel.this.clearTrackSelections();
                TrackNamePanel.this.selectTracks(e);
                IGV.getInstance().repaintNamePanels();
            }
            this.isDragging = false;
            this.dragTracks.clear();
            TrackNamePanel.this.dndImage = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Component c = e.getComponent();
            if (e.isPopupTrigger()) {
                return;
            }
            if (!this.isDragging) {
                if (this.dragStart == null) {
                    this.dragStart = e.getPoint();
                    return;
                }
                if (e.getPoint().distance(this.dragStart) < 5.0) {
                    return;
                }
                this.dragStart.x = TrackNamePanel.this.getWidth() / 2;
                IGV.getInstance().startDnD();
                if (TrackNamePanel.this.dndImage == null) {
                    TrackNamePanel.this.createDnDImage();
                }
                IGV.getInstance().getDnDGlassPane().setImage(TrackNamePanel.this.dndImage);
                this.isDragging = true;
                this.dragTracks.clear();
                this.dragTracks.addAll(IGV.getInstance().getSelectedTracks());
                TrackNamePanel.this.selectedGroup = TrackNamePanel.this.getGroups().size() > 0 ? TrackNamePanel.this.getGroup(e.getY()) : null;
            }
            if (this.isDragging) {
                final GhostGlassPane glassPane = IGV.getInstance().getDnDGlassPane();
                Point p = (Point)e.getPoint().clone();
                p.x = TrackNamePanel.this.getWidth() / 2;
                SwingUtilities.convertPointToScreen(p, c);
                SwingUtilities.convertPointFromScreen(p, glassPane);
                glassPane.setPoint(p);
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        Rectangle bounds = new Rectangle(TrackNamePanel.this.getBounds());
                        bounds.height = 10000;
                        glassPane.paintImmediately(bounds);
                    }
                });
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            TrackNamePanel.this.setToolTipText(TrackNamePanel.this.getTooltipTextForLocation(x, y));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            for (MouseableRegion mouseRegion : TrackNamePanel.this.mouseRegions) {
                Iterator<Track> iterator2;
                if (!mouseRegion.containsPoint(e.getX(), e.getY()) || !(iterator2 = mouseRegion.getTracks().iterator()).hasNext()) continue;
                Track t = iterator2.next();
                t.handleNameClick(e);
                return;
            }
        }

        protected void fireGhostDropEvent(GhostDropEvent evt) {
            Iterator<DropListener> it = dropListeners.iterator();
            while (it.hasNext()) {
                ((GhostDropListener)it.next()).ghostDropped(evt);
            }
        }
    }
}

