/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelComponent;
import org.broad.igv.ui.util.Packable;

public class AttributePanel
extends TrackPanelComponent
implements Packable,
Paintable {
    private static Logger log = Logger.getLogger(AttributePanel.class);

    public AttributePanel(TrackPanel trackPanel) {
        super(trackPanel);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.init();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle visibleRect = this.getVisibleRect();
        this.removeMousableRegions();
        this.paintOffscreen((Graphics2D)g, visibleRect);
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect) {
        TrackPanel trackPanel;
        List<TrackGroup> groups2;
        List<String> names = AttributeManager.getInstance().getAttributeNames();
        if (names == null) {
            return;
        }
        Set<String> hiddenAttributes = IGV.getInstance().getSession().getHiddenAttributes();
        if (hiddenAttributes != null) {
            names.removeAll(hiddenAttributes);
        }
        if (names.size() > 0 && !(groups2 = (trackPanel = (TrackPanel)this.getParent()).getGroups()).isEmpty()) {
            Graphics2D graphics2D = (Graphics2D)g.create();
            graphics2D.setColor(Color.BLACK);
            Graphics2D greyGraphics = (Graphics2D)g.create();
            greyGraphics.setColor(UIConstants.LIGHT_GREY);
            Graphics2D borderGraphics = (Graphics2D)g.create();
            borderGraphics.setColor(Color.lightGray);
            boolean left = true;
            int regionY = 0;
            int bottom = rect.y + rect.height;
            for (TrackGroup group : groups2) {
                if (regionY > bottom) break;
                if (!group.isVisible()) continue;
                if (groups2.size() > 1) {
                    greyGraphics.fillRect(0, regionY + 1, this.getWidth(), 9);
                    regionY += 10;
                }
                if (group.isDrawBorder()) {
                    g.drawLine(0, regionY - 1, this.getWidth(), regionY - 1);
                }
                for (Track track : group.getVisibleTracks()) {
                    int border;
                    if (track == null) continue;
                    int trackHeight = track.getHeight();
                    if (regionY > bottom) break;
                    if (!track.isVisible()) continue;
                    int n = border = trackHeight < 5 ? 0 : 1;
                    if (regionY + trackHeight >= rect.y) {
                        Rectangle trackRectangle = new Rectangle(1, regionY + border, this.getWidth(), trackHeight - border);
                        track.renderAttributes(graphics2D, trackRectangle, rect, names, this.mouseRegions);
                    }
                    regionY += trackHeight;
                }
                if (!group.isDrawBorder()) continue;
                g.drawLine(0, regionY, this.getWidth(), regionY);
            }
            int colWidth = 11;
            for (int x = 1; x < rect.x + rect.width; x += 11) {
                borderGraphics.fillRect(x + 10, rect.y, 1, rect.height);
            }
            graphics2D.dispose();
            greyGraphics.dispose();
            borderGraphics.dispose();
        }
    }

    private void init() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        if (!PreferencesManager.getPreferences().getAsBoolean("IGV.track.show.attribute.views")) {
            this.setSize(0, this.getHeight());
        }
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setPreferredSize(new Dimension(0, 0));
        this.setVerifyInputWhenFocusTarget(false);
        AttributePanelMouseAdapter mouseAdapter = new AttributePanelMouseAdapter();
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    @Override
    public String getPopupMenuTitle(int x, int y) {
        Collection<Track> selectedTracks = this.getSelectedTracks();
        int selectedTrackCount = selectedTracks.size();
        if (selectedTrackCount == 1) {
            return selectedTracks.iterator().next().getName();
        }
        String keyValue = "";
        for (MouseableRegion region : this.getMouseRegions()) {
            if (!region.containsPoint(x, y)) continue;
            keyValue = region.getText();
        }
        return keyValue + " (" + selectedTrackCount + " tracks)";
    }

    public String getMouseDoc(int x, int y) {
        List<MouseableRegion> mouseRegions = this.getMouseRegions();
        for (MouseableRegion mr : mouseRegions) {
            if (!mr.containsPoint(x, y)) continue;
            return mr.getText();
        }
        return "";
    }

    public int getAttributeColumnWidth() {
        return 10;
    }

    private int calculatePackWidth() {
        if (!PreferencesManager.getPreferences().getAsBoolean("IGV.track.show.attribute.views")) {
            return 0;
        }
        HashSet<String> attributeKeys = new HashSet<String>(AttributeManager.getInstance().getAttributeNames());
        Set<String> hiddenAttributes = IGV.getInstance().getSession().getHiddenAttributes();
        if (hiddenAttributes != null) {
            attributeKeys.removeAll(hiddenAttributes);
        }
        int attributeCount = attributeKeys.size();
        int packWidth = attributeCount * 11 + 1;
        return packWidth;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, this.calculatePackWidth(), height);
    }

    @Override
    public void packComponent() {
        int newWidth = this.calculatePackWidth();
        Dimension dimension = this.getSize();
        dimension = new Dimension(newWidth, dimension.height);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    class AttributePanelMouseAdapter
    extends MouseInputAdapter {
        int lastMousePressX = 0;

        AttributePanelMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (log.isDebugEnabled()) {
                log.debug("Enter mousePressed");
            }
            AttributePanel.this.clearTrackSelections();
            AttributePanel.this.selectTracks(e);
            if (e.isPopupTrigger()) {
                TrackClickEvent te = new TrackClickEvent(e, null);
                AttributePanel.this.openPopupMenu(te);
            }
            IGV.getInstance().repaintNamePanels();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TrackClickEvent te = new TrackClickEvent(e, null);
                AttributePanel.this.openPopupMenu(te);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            AttributePanel.this.setToolTipText(AttributePanel.this.getMouseDoc(e.getX(), e.getY()));
        }
    }
}

