/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;

public class UCSCUtils {
    private static Logger log = Logger.getLogger(UCSCUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertWIBFile(File txtFile, File wibFile, File wigFile, String trackLine) {
        BufferedReader txtReader = null;
        FileInputStream dataInputStream = null;
        PrintWriter wigWriter = null;
        String lastChr = "";
        int lastSpan = -1;
        try {
            String nextLine;
            txtReader = new BufferedReader(new FileReader(txtFile));
            dataInputStream = new FileInputStream(wibFile);
            wigWriter = new PrintWriter(new BufferedWriter(new FileWriter(wigFile)));
            if (trackLine != null) {
                wigWriter.println(trackLine);
            }
            while ((nextLine = txtReader.readLine()) != null) {
                String[] tokens2 = nextLine.split("\t");
                String chr = tokens2[1];
                int start = Integer.parseInt(tokens2[2]) + 1;
                int span = Integer.parseInt(tokens2[5]);
                if (!chr.equals(lastChr) || span != lastSpan) {
                    log.info("variableStep chrom=" + chr + " span=" + span);
                    wigWriter.println("variableStep chrom=" + chr + " span=" + span);
                    lastChr = chr;
                    lastSpan = span;
                }
                int count = Integer.parseInt(tokens2[6]);
                byte[] data = new byte[count];
                Integer offset = Integer.parseInt(tokens2[7]);
                dataInputStream.getChannel().position(offset.intValue());
                DataInputStream dis = new DataInputStream(dataInputStream);
                dis.readFully(data);
                double lowerLimit = Double.parseDouble(tokens2[9]);
                double dataRange = Double.parseDouble(tokens2[10]);
                int chromPosition = start;
                int i = 0;
                while (i < count) {
                    if (data[i] < 128) {
                        double value = lowerLimit + dataRange * ((double)data[i] / 127.0);
                        wigWriter.println(chromPosition + "\t" + value);
                    }
                    ++i;
                    chromPosition += span;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                txtReader.close();
                dataInputStream.close();
                wigWriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage convertWIGVile <txtFile> <wibFile> <wigFile> [trackLine]");
            System.exit(-1);
        }
        File txtFile = new File(args[0]);
        File wibFile = new File(args[1]);
        File wigFile = new File(args[2]);
        String trackLine = args.length > 3 ? args[3] : null;
        UCSCUtils.convertWIBFile(txtFile, wibFile, wigFile, trackLine);
    }
}

