/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.util.List;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentBlockImpl;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.track.WindowFunction;

public class FeatureWrappedAlignment
implements Alignment {
    String readName;
    String chr;
    int start;
    int end;
    AlignmentBlockImpl[] blocks;
    Strand strand;

    public FeatureWrappedAlignment(BasicFeature f) {
        this.readName = f.getName();
        this.chr = f.getChr();
        this.start = f.getStart();
        this.end = f.getEnd();
        this.strand = f.getStrand();
        if (f.getExonCount() > 0) {
            this.blocks = new AlignmentBlockImpl[f.getExonCount()];
            int i = 0;
            for (Exon exon : f.getExons()) {
                int length = exon.getLength();
                byte[] seq = new byte[length];
                this.blocks[i] = new AlignmentBlockImpl(exon.getStart(), seq, seq);
                ++i;
            }
        }
    }

    @Override
    public String getReadName() {
        return this.readName;
    }

    @Override
    public String getReadSequence() {
        return null;
    }

    public String getChromosome() {
        return this.chr;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public String getContig() {
        return this.chr;
    }

    @Override
    public int getAlignmentStart() {
        return this.start;
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.start && location <= (double)this.getEnd();
    }

    @Override
    public AlignmentBlock[] getAlignmentBlocks() {
        return this.blocks;
    }

    @Override
    public AlignmentBlock[] getInsertions() {
        return null;
    }

    @Override
    public String getCigarString() {
        return "*";
    }

    @Override
    public int getInferredInsertSize() {
        return 0;
    }

    @Override
    public int getMappingQuality() {
        return 255;
    }

    @Override
    public ReadMate getMate() {
        return null;
    }

    @Override
    public boolean isProperPair() {
        return true;
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public boolean isPaired() {
        return false;
    }

    @Override
    public boolean isNegativeStrand() {
        return this.strand == Strand.NEGATIVE;
    }

    @Override
    public boolean isDuplicate() {
        return false;
    }

    @Override
    public float getScore() {
        return 1.0f;
    }

    public LocusScore copy() {
        return this;
    }

    @Override
    public String getClipboardString(double location, int mouseX) {
        return this.getValueString(location, mouseX, null);
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        return this.readName + "<br>Read length = " + (this.getEnd() - this.getStart());
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public int getAlignmentEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public byte getBase(double position) {
        return 0;
    }

    @Override
    public byte getPhred(double position) {
        return 0;
    }

    @Override
    public String getSample() {
        return null;
    }

    @Override
    public String getReadGroup() {
        return null;
    }

    @Override
    public String getLibrary() {
        return null;
    }

    @Override
    public Object getAttribute(String key) {
        return null;
    }

    @Override
    public void setMateSequence(String sequence) {
    }

    @Override
    public String getPairOrientation() {
        return null;
    }

    public boolean isSmallInsert() {
        return false;
    }

    @Override
    public boolean isVendorFailedRead() {
        return false;
    }

    @Override
    public Color getYcColor() {
        return null;
    }

    @Override
    public List<Gap> getGaps() {
        return null;
    }

    @Override
    public boolean isFirstOfPair() {
        return false;
    }

    @Override
    public boolean isSecondOfPair() {
        return false;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        return this.strand;
    }

    @Override
    public Strand getSecondOfPairStrand() {
        return Strand.NONE;
    }

    @Override
    public Strand getReadStrand() {
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public boolean isSupplementary() {
        return false;
    }
}

