/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.awt.Color;
import java.util.List;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.MultiMap;

public class PAFFeature
implements IGVFeature {
    static Color defaultColor = new Color(0, 0, 150);
    private static int chrColumn = 5;
    private static int startColumn = 7;
    private static int endColumn = 8;
    private static int scoreColumn = 11;
    String chr;
    int start;
    int end;
    Strand strand;
    float score;
    String name;
    String description;

    public PAFFeature(String chr, int start, int end, Strand strand, float score, String name, String description) {
        this.chr = chr;
        this.start = start;
        this.end = end;
        this.strand = strand;
        this.score = score;
        this.name = name;
        this.description = description;
    }

    @Override
    public String getType() {
        return "Aignment";
    }

    @Override
    public String getIdentifier() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Strand getStrand() {
        return this.strand;
    }

    @Override
    public int getLength() {
        return this.end - this.start;
    }

    @Override
    public MultiMap<String, String> getAttributes() {
        return null;
    }

    @Override
    public boolean contains(IGVFeature feature) {
        if (feature == null) {
            return false;
        }
        if (!this.getChr().equals(feature.getChr()) || this.getStrand() != feature.getStrand()) {
            return false;
        }
        return feature.getStart() >= this.getStart() && feature.getEnd() <= this.getEnd();
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.getStart() && location < (double)this.getEnd();
    }

    @Override
    public List<Exon> getExons() {
        return null;
    }

    @Override
    public Color getColor() {
        return defaultColor;
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContig() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }
}

