/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.LineIterator;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;

public class IntervalListCodec
extends AsciiFeatureCodec<BasicFeature> {
    Genome genome;

    protected IntervalListCodec(Genome genome) {
        super(BasicFeature.class);
        this.genome = genome;
    }

    @Override
    public BasicFeature decode(String line) {
        if (line.startsWith("@")) {
            return null;
        }
        String[] tokens2 = Globals.whitespacePattern.split(line);
        String chr = tokens2[0];
        if (this.genome != null) {
            chr = this.genome.getCanonicalChrName(chr);
        }
        int start = Integer.parseInt(tokens2[1]) - 1;
        int end = Integer.parseInt(tokens2[2]);
        BasicFeature feature = new BasicFeature(chr, start, end);
        if (tokens2.length > 3) {
            String strandString = tokens2[3];
            Strand strand = Strand.fromString(strandString);
            feature.setStrand(strand);
        }
        if (tokens2.length > 4) {
            feature.setName(tokens2[4]);
        }
        return feature;
    }

    @Override
    public Object readActualHeader(LineIterator lineIterator) {
        return null;
    }

    @Override
    public boolean canDecode(String s) {
        return s.endsWith("interval_list");
    }
}

